% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib-dpareto2.R
\name{rdpareto2}
\alias{rdpareto2}
\alias{pdpareto2}
\alias{qdpareto2}
\alias{ddpareto2}
\title{Discretized Pareto Type-II (Lomax) Distribution [TO DO]}
\usage{
rdpareto2(n, k = 1, s = 1)

pdpareto2(q, k = 1, s = 1, lower.tail = TRUE)

qdpareto2(p, k = 1, s = 1, lower.tail = TRUE)

ddpareto2(x, k = 1, s = 1)
}
\arguments{
\item{n}{integer; number of observations}

\item{k}{vector of shape parameters, \eqn{k>0}}

\item{s}{vector of scale parameters, \eqn{s>0}}

\item{lower.tail}{logical; if \code{TRUE} (default),
probabilities are \eqn{P(X \le x)}, and \eqn{P(X > x)} otherwise}

\item{p}{vector of probabilities}

\item{x, q}{vector of quantiles}
}
\value{
numeric vector;
\code{ddpareto2} gives the probability mass function,
\code{pdpareto2} gives the cumulative distribution function,
\code{qdpareto2} calculates the quantile function,
and \code{rdpareto2} generates random deviates.
}
\description{
Probability mass function, cumulative distribution function,
quantile function, and random generation for the
Discretized Pareto Type-II distribution with shape
parameter \eqn{k>0} and scale parameter \eqn{s>0}.

[TO DO: rewrite in C, add NA handling, add working qdpareto2()]
}
\details{
If \eqn{X\sim\mathrm{DP2}(k,s)}{X~DP2(k,s)},
then \eqn{\lfloor Y\rfloor=X}{floor(Y)=X},
where \eqn{Y} has ordinary Pareto Type-II
distribution, see \code{\link{ppareto2}}.
}
\seealso{
Other distributions: 
\code{\link{rpareto2}()}

Other DiscretizedPareto2: 
\code{\link{dpareto2_estimate_mle}()}
}
\concept{DiscretizedPareto2}
\concept{distributions}
