% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_asym.R
\name{weight_asym}
\alias{weight_asym}
\title{Weighting method: Asymmetry of intervals}
\usage{
weight_asym(expert_judgements)
}
\arguments{
\item{expert_judgements}{the long tibble exported from the \code{preprocess_judgements} function.}
}
\value{
A tibble in the form of the input \code{expert_judgements} argument with additional columns
supplying the calculated weight for each row's observation.
}
\description{
Calculates weights by asymmetry of intervals
}
\details{
This function is used inside \link{IntervalWAgg} to calculate the weights for the
aggregation type \code{"AsymWAgg"}, \code{"IndIntAsymWAgg"} and \code{"KitchSinkWAgg"}. Pre-processed
expert judgements (long format) are first converted to wide format then weighted by:
\loadmathjax
\mjdeqn{w\_asym_{i,c}= \begin{cases}
1 - 2 \cdot \frac{U_{i,c}-B_{i,c}}{U_{i,c}-L_{i,c}}, \text{for}\ B_{i,c} \geq
\frac{U_{i,c}-L_{i,c}}{2}+L_{i,c}\cr
1 - 2 \cdot \frac{B_{i,c}-L_{i,c}}{U_{i,c}-L_{i,c}}, \text{otherwise}
\end{cases}}{ascii}

Data is converted back to long format, with only the weighted best estimates
retained.
}
\examples{
weight_asym(preprocess_judgements(data_ratings))
}
