% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_supp_reasons}
\alias{data_supp_reasons}
\title{Categories of reasons provided by participants for their expert judgements}
\format{
a tibble with 625 rows and 15 columns
\describe{
\item{paper_id}{character string for the paper ID}
\item{user_name}{character string for participant ID}
\item{RW04 Date of publication}{numeric; references to the date of publication, for example in relation to something being published prior to the 'replication crisis' within the relevant discipline, or a study being difficult to re-run now because of changes in social expectations. }
\item{RW15 Effect size}{numeric; any references to the effect size that indicate that the participant considered the size of the effect when assessing the claim. Don’t use if the term "effect size" is used in unrelated ways, but err on the side of considering statements as relevant to the participant’s assessment.}
\item{RW16 Interaction effect}{numeric; references to when the effect was an interaction effect (rather than a direct effect).}
\item{RW17 Interval or range measure for statistical uncertainty (CI, SD, etc )}{numeric; references to the inclusion, absence, or size of the uncertainty measure for a given effect.}
\item{RW18 Outside participants areas of expertise}{numeric; references to the claim under assessment being outside the participant's areas of expertise.}
\item{RW20 Plausibility}{numeric; references to the plausibility of the claim.}
\item{RW21 Population or subject characteristics (sampling practices)}{numeric; references to the characteristics of the sample population or subjects used in a study that affect the participant’s assessment of the claim, including references to low response rate and any other questions or appreciation of the sampling practices.}
\item{RW22 Power adequacy and or sample size}{numeric; combines 2 nodes for references to the adequacy (or not) of the statistical power of the study &/or sample size.}
\item{RW32 Reputation}{numeric; references to the reputation of the journal/institute/author.}
\item{RW37 Revision statements}{numeric; .}
\item{RW42 Significance, statistical (p-value etc )}{numeric; references to a test of statistical significance for the claim as it impacts on the participant’s assessment. This explicitly includes p-values, t-values, critical alpha and p-rep.}
}
}
\usage{
data_supp_reasons
}
\description{
Categories of reasons provided by participants for their expert judgements
}
\keyword{datasets}
