% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{am_data}
\alias{am_data}
\title{Retrieve Data from the Database}
\usage{
am_data(
  ctry = africamonitor::am_countries$ISO3,
  series = NULL,
  from = NULL,
  to = NULL,
  labels = TRUE,
  wide = TRUE,
  expand.date = FALSE,
  drop.1iso3c = TRUE,
  ordered = TRUE,
  return.query = FALSE,
  ...
)
}
\arguments{
\item{ctry}{character. (Optional) the ISO3 code of countries (see \code{\link{am_countries}}). Default is to load data for all African countries. Putting \code{NULL} gets data for all countries (codes available in \code{\link{am_countries_wld}}).}

\item{series}{character. (Optional) codes of series matching the 'Series' column of the series table (retrieved using \code{\link[=am_series]{am_series()}}).}

\item{from}{set the start time of the data retrieved by either supplying a start date, a date-string of the form \code{"YYYY-MM-DD"} or \code{"YYYY-MM"},
year-quarters of the form \code{"YYYYQN"} or \code{"YYYY-QN"}, a numeric year \code{YYYY} (numeric or character), or a fiscal year of the form \code{"YYYY/YY"}. These expressions are converted to a regular date by \code{\link{am_as_date}}.}

\item{to}{same as \code{from}: to set the time period until which data is retrieved. For expressions that are not full "YYYY-MM-DD" dates, the last day of the period is chosen.}

\item{labels}{logical. \code{TRUE} will also return labels (series descriptions) along with the series codes.}

\item{wide}{logical. \code{TRUE} calls \code{\link{am_pivot_wider}} on the result. \code{FALSE} returns the data in a long format without missing values (suitable for \code{ggplot2}).}

\item{expand.date}{logical. \code{TRUE} will call \code{\link{am_expand_date}} on the result.}

\item{drop.1iso3c}{logical. If only one country is selected through \code{ctry}, \code{TRUE} will drop the 'ISO3' column in the output.}

\item{ordered}{logical. \code{TRUE} orders the result by 'Date' and, if \code{labels = TRUE}, by series, maintaining a fixed column-order of series.
\code{FALSE} returns the result in a random order, to the benefit of faster query execution.}

\item{return.query}{logical. \code{TRUE} will not query the database but instead return the constructed SQL query as a character string (for debugging purposes).}

\item{\dots}{further arguments passed to \code{\link{am_pivot_wider}} (if \code{wide = TRUE}) or \code{\link{am_expand_date}} (if \code{expand.date = TRUE}).}
}
\value{
A \code{\link[data.table]{data.table}} with the result of the query.
}
\description{
This is the main function of the package to retrieve data from the database. % It constructs an SQL query which is sent to the database and returns the data as a \code{\link[data.table]{data.table}} in R.
}
\details{
If \code{labels = FALSE}, the series table is not joined to the data table, and \code{ordered = TRUE} will order series retrieved in alphabetic order.
If \code{labels = TRUE} data is ordered by series and date, preserving the order of columns in the dataset. If multiple countries are received they are ordered alphabetically according to the 'ISO3' column.

Series at different frequencies can be queried, but, if \code{wide = TRUE}, this will result in missing values for all but the first observations per period in the lower frequency series.
}
\examples{
\donttest{
# Return all indicators for Kenya from 2000
am_data("KEN", from = 2000)

# Return all indicators for Kenya from 2000 in long format
am_data("KEN", from = 2000, wide = FALSE)

# Return with date expanded
am_data("KEN", from = 2000, expand.date = TRUE)

# Same thing in multiple steps (with additional customization options):
am_data("KEN", from = 2000, wide = FALSE) |> am_pivot_wider() |> am_expand_date()

# Getting only GDP growth
am_data("KEN", "NGDP_RPCH", from = 2000)

# Getting GDP growth for all countries
am_data(series = "NGDP_RPCH", from = 2000)

# Reshaping to wider format
am_data(series = "NGDP_RPCH", from = 2000) |>
  am_pivot_wider(id_cols = "Date",
                 names_from = "ISO3",
                 values_from = "NGDP_RPCH")

# Getting growth and inflation for the EAC countries (all available years)
am_data(ctry = c("UGA", "KEN", "TZA", "RWA", "BDI", "SSD"),
        series = c("NGDP_RPCH", "PCPIPCH"))

}
}
\seealso{
\code{\link{am_pivot_wider}}, \code{\link{am_expand_date}}, \code{\link{africamonitor}}
}
