% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_continuous_af.R
\name{scale_colour_continuous_af}
\alias{scale_colour_continuous_af}
\title{Continuous colour scales for Analysis Function plots}
\usage{
scale_colour_continuous_af(
  palette = "sequential",
  palette_type = c("af"),
  reverse = FALSE,
  na_colour = "grey50",
  guide = "colourbar",
  ...
)
}
\arguments{
\item{palette}{Name of palette to use; e.g. "main", "sequential", "focus".
Default value is "sequential".}

\item{palette_type}{Currently only the Analysis Function palettes are
supported. Defaults to "af".}

\item{reverse}{Boolean value to indicate whether the palette should be
reversed.}

\item{na_colour}{Colour to set for missing values.}

\item{guide}{A name or function used to create guide. Default is "colourbar".}

\item{...}{Additional arguments passed to scale type.}
}
\value{
ggplot2 continuous colour scale
}
\description{
Continuous colour scales for Analysis Function plots
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(x = mpg, y = wt, colour = cyl)) +
  geom_point() +
  scale_colour_continuous_af()

}
