% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afc.dd.R
\name{afc.dd}
\alias{afc.dd}
\title{2AFC For Dichotomous Observations And Dichotomous Forecasts}
\usage{
afc.dd(obsv, fcst)
}
\arguments{
\item{obsv}{vector with dichotomous observations (values in {0,1})}

\item{fcst}{vector of same length as \emph{obsv} with dichotomous forecasts
(values in {0,1})}
}
\value{
\item{ p.afc }{ Value of Generalized Discrimination (2AFC) Score }
}
\description{
Routine to calculate the Generalized Discrimination Score (aka
Two-Alternatives Forced Choice Score 2AFC) for the situation of dichotomous
observations and dichotomous forecasts
}
\details{
This routine applies Eq.2 of Mason and Weigel (2009) to calculate the 2AFC.
}
\examples{

  #Forecasts and observations of Nino-3.4 index
  #Load set of dichotomous observations and dichotomous forecasts
  data(cnrm.nino34.dd)
  obsv = cnrm.nino34.dd$obsv
  fcst = cnrm.nino34.dd$fcst

  #Calculate skill score
  afc.dd(obsv,fcst)

}
\references{
S.J. Mason and A.P. Weigel, 2009. A generic verification
framework for administrative purposes. Mon. Wea. Rev., 137, 331-349
}
\seealso{
\code{\link{afc}}
}
\author{
Andreas Weigel, Federal Office of Meteorology and Climatology,
MeteoSwiss, Zurich, Switzerland
}
\keyword{file}
