% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afc-package.R
\docType{package}
\name{afc-package}
\alias{afc-package}
\title{Generalized Discrimination Score 2AFC}
\description{
This package is a collection of routines to calculate the "generalized
discrimination score", which is also known as "two alternatives
forced-choice score" or short: "2AFC-score". The 2AFC is a generic forecast
verification framework which can be applied to any of the following
verification contexts: dichotomous, polychotomous (ordinal and nominal),
continuous, probabilistic, and ensemble. A comprehensive description of the
2AFC-score, including all equations used in this package, is provided by
Mason and Weigel (2009).
}
\details{
The master routine is \code{\link{afc}}. For a given set of observation and
forecast data, and for a specified verification context, \code{\link{afc}}
calls the appropriate functions which are necessary to calculate the 2AFC
score.

Why the 2AFC-score? There are numerous reasons for calculating forecast
verification scores, and considerable attention has been given to designing
and analyzing the properties of scores that can be used for scientific
purposes. Much less attention has been given to scores that may be useful
for administrative reasons, such as communicating changes in forecast
quality to bureaucrats, and providing indications of forecast quality to the
general public. The 2AFC test a scoring procedure that is sufficiently
generic to be useable on forecasts ranging from simply "yes"/"no" forecasts
of dichotomous outcomes to continuous variables, and can be used with
deterministic or probabilistic forecasts without seriously reducing the more
complex information when available. Although, as with any single
verification score, the 2AFC has limitations, it does have broad intuitive
appeal in that the expected score of an unskilled set of forecasts (random
guessing or perpetually identical forecasts) is 50\%, and is interpretable
as an indication of how often the forecasts are correct, even when the
forecasts are expressed probabilistically and/or the observations are not
discrete.

\tabular{ll}{ Package: \tab afc\cr Version: \tab 1.03\cr Date: \tab
2010-01-07\cr License: \tab GPL-2\cr }
}
\section{Index}{
 
\preformatted{
afc                     Calculate Generalized Discrimination Score 2AFC
afc-package             Generalized Discrimination Score 2AFC
afc.cc                  2AFC For Continuous Observations And Continuous 
                        Forecasts
afc.ce                  2AFC For Ordinal Polychotomous Observations And
                        Ensemble Forecasts
afc.dc                  2AFC For Dichotomous Observations And
                        Continuous Forecasts
afc.dd                  2AFC For Dichotomous Observations And
                        Dichotomous Forecasts
afc.de                  2AFC for Dichotomous Observations and Ensemble
                        Forecasts
afc.dm                  2AFC For Dichotomous Observations And
                        Polychotomous Forecasts
afc.dp                  2AFC For Dichotomous Observations And
                        Probabilistic Forecasts
afc.mc                  2AFC For Ordinal Polychotomous Observations And
                        Continuous Forecasts
afc.me                  2AFC For Ordinal Polychotomous Observations And
                        Ensemble Forecasts
afc.mm                  2AFC For Ordinal Polychotomous Observations And
                        Ordinal Polychotomous Forecasts
afc.mp                  2AFC For Ordinal Polychotomous Observations And
                        Probabilistic Forecasts
afc.nn                  2AFC For Nominal Polychotomous Observations And
                        Nominal Polychotomous Forecasts
afc.np                  2AFC For Nominal Polychotomous Observations And
                        Probabilistic Forecasts
cnrm.nino34.cc          Example Data of Continuous Observations and
                        Continuous Forecasts
cnrm.nino34.ce          Example Data of Continuous Observations and 
                        Ensemble Forecasts
cnrm.nino34.dc          Example Data of Dichotomous Observations and
                        Continuous Forecasts
cnrm.nino34.dd          Example Data of Dichotomous Observations and
                        Dichotomous Forecasts
cnrm.nino34.de          Example Data of Dichotomous Observations and
                        Ensemble Forecasts
cnrm.nino34.dm          Example Data of Dichotomous Observations and
                        Polychotomous Forecasts
cnrm.nino34.dp          Example Data of Dichotomous Observations and
                        Polychotomous Forecasts
cnrm.nino34.mc          Example Data of Polychotomous Observations and
                        Continuous Forecasts
cnrm.nino34.me          Example Data of Polychotomous Observations and
                        Ensembles Forecasts
cnrm.nino34.mm          Example Data of Polychotomous Observations and
                        Polychotomous Forecasts
cnrm.nino34.mp          Example Data of Polychotomous Observations and
                        Probabilistic Forecasts
rank.ensembles          Rank Ensembles
}
}

\references{
Mason, S.J. and A.P. Weigel, 2009: A generic forecast
verification framework for administrative purposes. Mon. Wea. Rev., 137,
331-349
}
\author{
Andreas Weigel, Federal Office of Meteorology and Climatology
(MeteoSwiss), Zurich, Switzerland <andreas.weigel@meteoswiss.ch>
}
\keyword{package}
