% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_temkinNLM.R
\name{mcmc_temkinNLM}
\alias{mcmc_temkinNLM}
\title{MCMC Analysis for Temkin Isotherm Non-linear Model}
\arguments{
\item{Ce}{Numeric vector of equilibrium concentrations.}

\item{Qe}{Numeric vector of adsorbed amounts.}

\item{Temp}{Numeric value of temperature in Kelvin.}

\item{burnin}{Integer specifying the number of burn-in iterations (default is 1000).}

\item{mcmc}{Integer specifying the total number of MCMC iterations (default is 5000).}

\item{thin}{Integer specifying the thinning interval (default is 10).}

\item{verbose}{Integer controlling the frequency of progress updates (default is 100).}

\item{plot}{Logical; if TRUE, trace and density plots of the MCMC chains are shown (default is FALSE).}

\item{n_chains}{Number of independent MCMC chains (default = 2).}

\item{seed}{Optional integer for reproducibility.}
}
\value{
A list containing:
\describe{
  \item{AT_mean}{Posterior mean estimate of Temkin constant (AT).}
  \item{bT_mean}{Posterior mean estimate of Temkin constant (bT).}
  \item{logAT_mean}{Posterior mean of (log(AT)).}
  \item{bT_sd}{Posterior standard deviation for (bT).}
  \item{logAT_sd}{Posterior standard deviation for (log(AT)).}
  \item{logAT_ci}{95\% credible interval for (log(AT)).}
  \item{bT_ci}{95\% credible interval for (bT).}
  \item{gelman_diag}{Gelman-Rubin diagnostics (only if multiple chains).}
  \item{mcmc_summary}{Summary statistics for each parameter.}
}
}
\description{
Performs Bayesian parameter estimation using Markov Chain Monte Carlo (MCMC)
for the non-linear Temkin isotherm model:
Qe = (R * T / b_T) * ln(A_T * Ce)
This approach is applied to obtain a probabilistic distribution of the model parameters, capturing uncertainties
and potential correlations between them.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
mcmc_temkinNLM(Ce, Qe, 298, burnin = 1000, mcmc = 5000, thin = 10,
               verbose = 100, plot = TRUE, n_chains = 2, seed = 123)
}
\references{
Gilks, W. R., Richardson, S., & Spiegelhalter, D. J. (1995). \emph{Markov Chain Monte Carlo in Practice}. Chapman and Hall/CRC.
}
\author{
Paul Angelo C. Manlapaz
}
