% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_freundlichLM.R
\name{mcmc_freundlichLM}
\alias{mcmc_freundlichLM}
\title{MCMC Analysis for Freundlich Isotherm Linear Model}
\arguments{
\item{Ce}{Numeric vector of equilibrium concentrations.}

\item{Qe}{Numeric vector of adsorbed amounts.}

\item{burnin}{Integer specifying the number of burn-in iterations (default is 1000).}

\item{mcmc}{Integer specifying the total number of MCMC iterations (default is 5000).}

\item{thin}{Integer specifying the thinning interval (default is 10).}

\item{verbose}{Integer controlling the frequency of progress updates (default is 100).}

\item{plot}{Logical; if TRUE, trace and density plots of the MCMC chains are shown (default is FALSE).}

\item{n_chains}{Number of independent MCMC chains (default = 2).}

\item{seed}{Optional integer for reproducibility.}
}
\value{
A list containing:
\describe{
  \item{mcmc_results}{An object of class \code{mcmc.list} containing posterior samples from all MCMC chains. Each chain includes samples of the intercept and slope.}
  \item{Kf_mean}{Posterior mean estimate of the Freundlich constant (Kf).}
  \item{n_mean}{Posterior mean estimate of the Freundlich exponent (n).}
  \item{logKf_mean}{Posterior mean of (log(Kf)) from the first MCMC chain.}
  \item{inv_n_mean}{Posterior mean of (1/n) (the slope) from the first MCMC chain.}
  \item{logKf_sd}{Posterior standard deviation of (log(Kf)), quantifying uncertainty in the intercept estimate.}
  \item{inv_n_sd}{Posterior standard deviation of (1/n), quantifying uncertainty in the slope estimate.}
  \item{logKf_ci}{95\% credible interval for (log(Kf)) from the first MCMC chain, representing the posterior uncertainty in the intercept.}
  \item{inv_n_ci}{95\% credible interval for (1/n) from the first MCMC chain, representing the posterior uncertainty in the slope.}
  \item{gelman_diag}{Gelman-Rubin diagnostic output from \code{coda::gelman.diag()}, used to assess convergence of the multiple MCMC chains. A potential scale reduction factor (PSRF) close to 1 indicates good convergence.}
  \item{mcmc_summary}{Summary statistics of the first MCMC chain, including means, standard deviations, quantiles, and sample sizes for each parameter.}
}
}
\description{
Performs Bayesian parameter estimation using Markov Chain Monte Carlo (MCMC)
to estimate the parameters of the Freundlich isotherm based on its linearized form:
log(Qe) = log(Kf) + (1/n)log(Ce)
This method provides a probabilistic interpretation of the model parameters and accounts for their uncertainties.
It supports multiple MCMC chains and computes convergence diagnostics (Gelman-Rubin).
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
mcmc_freundlichLM(Ce, Qe, burnin = 1000, mcmc = 5000, thin = 10,
                  verbose = 100, plot = TRUE, n_chains = 2, seed = 123)
}
\references{
Gilks, W. R., Richardson, S., & Spiegelhalter, D. J. (1995). \emph{Markov Chain Monte Carlo in Practice}. Chapman and Hall/CRC.
}
\author{
Paul Angelo C. Manlapaz
}
