% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_freundlichLM.R
\name{fit_freundlichLM}
\alias{fit_freundlichLM}
\title{Freundlich Isotherm Linear Analysis}
\arguments{
\item{Ce}{numeric vector for equilibrium concentration}

\item{Qe}{numeric vector for adsorbed amount}

\item{verbose}{logical; if TRUE (default), prints summary and messages}
}
\value{
A list containing the results of the linear Freundlich model fitting, including:
\itemize{
  \item \strong{Parameter estimates} for the Freundlich model (KF and n).
  \item \strong{Fit statistics} such as Akaike Information Criterion (AIC), Bayesian Information Criterion (BIC), and R-squared.
  \item \strong{Error metrics} including Root Mean Square Error (RMSE), Mean Absolute Error (MAE), Mean Squared Error (MSE), Relative Absolute Error (RAE), and standard error of estimates.
  \item A \strong{model fit plot} with bootstrapped 95% confidence intervals.
  \item A \strong{residual plot} for diagnostic assessment of model performance.}
}
\description{
Performs linear modeling for the Freundlich adsorption isotherm using log-transformed data.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
fit_freundlichLM(Ce, Qe, verbose = TRUE)
fit_freundlichLM(Ce, Qe)

}
\references{
Freundlich, H. 1907. Ueber die adsorption in loesungen. Z. Phys. Chem.57:385-470
}
\author{
Paul Angelo C. Manlapaz
}
