% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crrscCOX.R
\name{crrscCOX}
\alias{crrscCOX}
\title{Stratified Competing Proportional Subdistribution Hazards Model For Clustered Competing Risks Data With Covariate-Dependent Censoring}
\usage{
crrscCOX(
  times,
  causes,
  covariates,
  cencovariates,
  treatment = NULL,
  clusters = 1:length(times),
  cencode = 0,
  failcode = 1,
  treatmentC = NULL,
  stratified.model = TRUE,
  stratified.model.cens = TRUE,
  est.t = FALSE,
  pre.t = sort(times[causes == failcode]),
  Z0 = NULL
)
}
\arguments{
\item{times}{Failure/censored times.}

\item{causes}{Failure code for each failure type (1 or 2) and 0 for censoring.}

\item{covariates}{Matrix of covariates. Dummy variables must be created for categorical covariates.}

\item{cencovariates}{Matrix of covariates for censoring. Dummy variable must be created
for categorical covariates.}

\item{treatment}{Treatment variable.}

\item{clusters}{Cluster variable. Independent data is assumed if this is not provided.}

\item{cencode}{Code for censoring. By default it is 0.}

\item{failcode}{Code for the failure type of interest. By default it is 1.}

\item{treatmentC}{Treatment variable for censoring. Could also be stratification variable.}

\item{stratified.model}{\code{TRUE} or \code{FALSE}. By default, it is \code{TRUE} for stratified model. The stratification variable is \code{treatment}.
If this is \code{FALSE} and \code{est.t=TRUE}, then the \code{treatment} variable still needs to be provided and will be used as a covariate.}

\item{stratified.model.cens}{\code{TRUE} or \code{FALSE}. By default, it is \code{TRUE} for stratified model for censoring. For unstratified model \code{treatmentC} does not need to be provided.}

\item{est.t}{\code{TRUE} or \code{FALSE}. By default this is \code{FALSE}. If it is \code{TRUE} then estimates of cumulative baseline hazard, adjusted cumulative incidence and predicted cumulative incidence are provided along with their standard errors at pre-specified time points.}

\item{pre.t}{Pre-specified time points.
By default these are all main event times.}

\item{Z0}{Covariate vector for prediction. By default this vector is a zero vector.}
}
\value{
Returns a list with the following components. If \code{est.t=FALSE} then only upto
$nstrataC are provided.
\item{$coef}{Parameter estimates}
\item{$p.value}{p-value of regression coefficients}
\item{$var}{Covariance matrix of parameter estimates}
\item{$infor}{Information matrix}
\item{$loglikelihood}{Maximum log-likelihood value}
\item{$n}{Total number of observations used}
\item{$nevents}{Total number of events and censored observations}
\item{$nclusters}{Total number of clusters}
\item{$nstrata}{Total number of treatment groups}
\item{$nstrataC}{Total number of treatment groups for censoring}
\item{$CumBaseHaz.t}{Cumulative basline hazard estimates and their standard errors}
\item{$Fpredict.t}{Predicted cumulative incidence and their standard errors}
\item{$AdjustedF.t}{Adjusted cumulative incidence and their standard errors}
\item{$Adjusted.se.diff}{Standard error of the difference of adjusted cumulative incidence between the treatment groups}
}
\description{
Stratified proportional subdistribution hazards model for clustered competing risks data. 
The stratified Cox proportional hazards model is fitted
for the censoring distribution. 
The estimates of the cumulative baseline hazard along with their standard errors are provided at the
pre-specified time points.
Furthermore, the adjusted cumulative incidence rates along with their standard errors are calculated at pre-specified time points. The standard error of the
the difference in adjusted cumulative incidence between the groups are also provided.
Finally, the estimates of adjusted cumulative incidence rates given vector \code{Z0} along with their standard errors are provided at
pre-specified time points. Tied data are handled by adding a tiny random shift from a normal distribution with mean 0 and standard deviation
1e-09.
}
\examples{
#Simulated data
alpha = 0.5
d = simulate_CR_data(n=4,m=50,alpha=alpha,beta1=c(0.7,-0.7,-0.5)*1/alpha,
beta2=c(0.5,-0.5,1),betaC=c(2,-2,1)*1/alpha,lambdaC=0.59)

#Note: Since est.t=TRUE, model1 through model4 below will also output the 
#estimates of cumulative baseline hazard, adjusted probabilities and predicted 
#probabilities along with their standard errors.

#Stratified Model for the main cause and stratified model for censoring
model1 <- crrscCOX(times=d[,1],causes=d[,2],covariates=d[,4:5],cencovariates=d[,4:5],
treatment=d[,3],clusters=d[,6],treatmentC=d[,3],stratified.model=TRUE,
est.t=TRUE,stratified.model.cens=TRUE,pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Unstratified Model for the main cause and stratified model for censoring
model2 <- crrscCOX(times=d[,1],causes=d[,2],covariates=d[,4:5],cencovariates=d[,4:5],
treatment=d[,3],clusters=d[,6],treatmentC=d[,3],stratified.model=FALSE,
stratified.model.cens=TRUE,est.t=TRUE,pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Stratified Model for the main cause and unstratified model for censoring
model3 <- crrscCOX(times=d[,1],causes=d[,2],covariates=d[,4:5],cencovariates=d[,4:5],
treatment=d[,3],clusters=d[,6],stratified.model=TRUE,
est.t=TRUE,stratified.model.cens=FALSE,pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Unstratified Model for the main cause and unstratified model for censoring
model4 <- crrscCOX(times=d[,1],causes=d[,2],covariates=d[,4:5],cencovariates=d[,4:5],
treatment=d[,3],clusters=d[,6],stratified.model=FALSE,
stratified.model.cens=FALSE,est.t=TRUE,pre.t=sort(d$time[d$cause==1]),Z0=c(0.5,0.5))

#Now set est.t=FALSE which means the cumulative baseline hazard estimate, adjusted
#probabilities and predicted cumulative incidence are not returned.

#Assume only continuous covariates are available for main cause and censoring.
#In this case both stratified.model and stratified.model.cens need to be FALSE.
model5 <- crrscCOX(times=d[,1],causes=d[,2],covariates=d[,4:5],cencovariates=d[,4:5],
clusters=d[,6],stratified.model=FALSE,stratified.model.cens=FALSE,est.t=FALSE)
}
