% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_p}
\alias{plot_p}
\title{Plot p-values and implied rejection boundaries}
\usage{
plot_p(
  estimator,
  data_distribution,
  design,
  mu = 0,
  sigma,
  boundary_color = "lightgreen",
  subdivisions = 100,
  ...
)
}
\arguments{
\item{estimator}{object of class \code{PointEstimator}, \code{IntervalEstimator} or \code{PValue}.}

\item{data_distribution}{object of class \code{Normal} or \code{Student}.}

\item{design}{object of class \code{TwoStageDesign}.}

\item{mu}{expected value of the underlying normal distribution.}

\item{sigma}{assumed standard deviation.}

\item{boundary_color}{color of the implied rejection boundary.}

\item{subdivisions}{number of subdivisions per axis for the grid of test statistic values.}

\item{...}{additional arguments handed down to ggplot}
}
\value{
a \code{\link[ggplot2]{ggplot}} object visualizing the p-values on a grid of possible test-statistic values.
}
\description{
Creates a plot of the p-values and implied rejection boundaries on a grid
of values for the first and second-stage test statistics.
}
\details{
When the first-stage test statistic lies below the futility threshold (c1f) or
above the early efficacy threshold (c1e) of the \code{TwoStageDesign},
there is no second-stage test statistics. The p-values in these regions are only
based on the first-stage values.
For first-stage test statistic values between c1f and c1e, the first and second-stage
test statistic determine the p-value.

The rejection boundary signals the line where
}
\examples{
plot_p(estimator = StagewiseCombinationFunctionOrderingPValue(),
  data_distribution = Normal(FALSE),
  design = get_example_design(),
  mu = 0,
  sigma = 1)
}
