% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\docType{class}
\name{IntervalEstimator-class}
\alias{IntervalEstimator-class}
\alias{ConfidenceInterval}
\alias{ConfidenceInterval-class}
\alias{IntervalEstimator}
\alias{RepeatedCI}
\alias{StagewiseCombinationFunctionOrderingCI}
\alias{MLEOrderingCI}
\alias{LikelihoodRatioOrderingCI}
\alias{ScoreTestOrderingCI}
\alias{NeymanPearsonOrderingCI}
\alias{NaiveCI}
\title{Interval estimators}
\usage{
IntervalEstimator(two_sided, l1, u1, l2, u2, label)

RepeatedCI(two_sided = TRUE)

StagewiseCombinationFunctionOrderingCI(two_sided = TRUE)

MLEOrderingCI(two_sided = TRUE)

LikelihoodRatioOrderingCI(two_sided = TRUE)

ScoreTestOrderingCI(two_sided = TRUE)

NeymanPearsonOrderingCI(two_sided = TRUE, mu0 = 0, mu1 = 0.4)

NaiveCI(two_sided = TRUE)
}
\arguments{
\item{two_sided}{logical indicating whether the confidence interval is two-sided.}

\item{l1}{functional representation of the lower boundary of the interval in the early futility and efficacy regions.}

\item{u1}{functional representation of the upper boundary of the interval in the early futility and efficacy regions.}

\item{l2}{functional representation of the lower boundary of the interval in the continuation region.}

\item{u2}{functional representation of the upper boundary of the interval in the continuation region.}

\item{label}{name of the estimator. Used in printing methods.}

\item{mu0}{expected value of the normal distribution under the null hypothesis.}

\item{mu1}{expected value of the normal distribution under the null hypothesis.}
}
\value{
an object of class \code{IntervalEstimator}. This class signals that an
object can be supplied to the \code{\link{evaluate_estimator}} and the
\code{\link{analyze}} functions.
}
\description{
This is the parent class for all confidence intervals implemented in this package.
Currently, only confidence intervals for the parameter \eqn{\mu} of a normal distribution
are implemented. Details about the methods for calculating confidence intervals can be found in
(our upcoming paper).
}
\details{
The implemented confidence intervals are:
\itemize{
\item \code{MLEOrderingCI()}
\item \code{LikelihoodRatioOrderingCI()}
\item \code{ScoreTestOrderingCI()}
\item \code{StagewiseCombinationFunctionOrderingCI()}
}

These confidence intervals are constructed by specifying an ordering of the sample space
and finding the value of \eqn{\mu}, such that the observed sample is the
\eqn{\alpha/2} (or (\eqn{1-\alpha/2})) quantile of the sample space according to the
chosen ordering.
Some of the implemented orderings are based on the work presented in
\insertCite{emerson1990parameter}{adestr},
\insertCite{@Sections 8.4 in @jennison1999group}{adestr},
and \insertCite{@Sections 4.1.1 and 8.2.1 in @wassmer2016group}{adestr}.
}
\examples{
# This is the definition of the 'naive' confidence interval for one-armed trials
IntervalEstimator(
  two_sided = TRUE,
  l1 = \(smean1, n1, sigma, ...) smean1 - qnorm(.95, sd = sigma/sqrt(n1)),
  u1 = \(smean1, n1, sigma, ...) smean1 + qnorm(.95, sd = sigma/sqrt(n1)),
  l2 = \(smean1, smean2, n1, n2, sigma, ...) smean2 - qnorm(.95, sd = sigma/sqrt(n1 + n2)),
  u2 = \(smean1, smean2, n1, n2, sigma, ...) smean2 + qnorm(.95, sd = sigma/sqrt(n1 + n2)),
  label="My custom CI")
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{evaluate_estimator}}
}
