% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reestimate_samplesize.R
\name{rss}
\alias{rss}
\title{Reestimate the sample size for the adaptive design in bioequivalence (BE) studies using mixed criterion.}
\usage{
rss(n, r, S_WR, params = list(), nsim = 1000, ncores = NULL)
}
\arguments{
\item{n}{The number of donors in each simulation.}

\item{r}{The number of replicates from each donor for each simulated dataset.}

\item{S_WR}{The estimated standard deviation of the reference measurements. The reference-scaled average bioequivalence approach is used if S_WR > 0.249 and the average bioequivalence approach otherwise.}

\item{params}{(Optional) The list of true parameters to be assumed in data generation.
\itemize{
\item \code{sigma_W0} - A regulatory constant set by the FDA. Defaults to 0.25.
\item \code{GMR} - The geometric mean ratio of the test and reference values of the pharmacokinetic measures (e.g., Jmax or AUC). If the test-formulation measure is greater than that of the reference formulation, then GMR is typically set to 1.05, which is the initial value of this function. If the reference-formulation measure is bigger, then GMR is typically 0.95. Defaults to 0.95.
\item \code{m} - Another regulatory constant that determines the bounds within which the estimated GMR should fall for bioequivalence to be established. Defaults to 1.25, representing 80-125\% average BE limits, which is the FDA recommendation.
\item \code{sig_level} - The significance level (alpha-level).
\item \code{nmax} - The upper limit for sample size reestimation. If the sample size exceeds \code{nmax} inside estimation procedure, the function will return \code{nmax}.
\item \code{target_power} - The threshold for power (or passing rate) for a hypothesis test to be considered powerful. Typically set at 80\% and defaults to 0.8.
}}

\item{nsim}{(Optional) The number of total simulations to be conducted. Defaults to 1,000.}

\item{ncores}{(Optional) The number of CPU cores to use for parallel processing (OpenMP). If R hasn't been installed with OpenMP configured, this will not take effect. When OpenMP is available, it should not exceed the number of existing cores. If unspecified, it will default to 2 cores or the number of existing cores, whichever is smaller.}
}
\value{
A list of lists
\itemize{
\item \code{parameters} - A list of true parameter settings.
\item \code{rss} - The reestimated sample size.
\item \code{runtime} - The total elapsed time charged for the execution of the program.
}
}
\description{
This function reestimates the sample size using mixed criterion required for target power, using binary search. The power (passing rate) function of mixed criterion testing lacks a closed-form expression. Thus, sample size (re-)estimation requires a binary search, after identifying an \code{n} where the passing rate exceeds the desired level.
}
\examples{
out <- rss(10, 6, S_WR = 0.22, nsim = 2)

}
\references{
Potvin, D., DiLiberti, C. E., Hauck, W. W., Parr, A. F., Schuirmann, D. J., & Smith, R. A. (2008). Sequential design approaches for bioequivalence studies with crossover designs. Pharmaceutical Statistics: The Journal of Applied Statistics in the Pharmaceutical Industry, 7(4), 245-262.
}
\author{
Daeyoung Lim, \email{daeyoung.lim@uconn.edu}
}
