% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_prod_mat_funct.R
\name{int_prod_mat_funct}
\alias{int_prod_mat_funct}
\title{Interior product between matrices for FDA}
\usage{
int_prod_mat_funct(m, PM)
}
\arguments{
\item{m}{Data matrix.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}
}
\value{
Data matrix.
}
\description{
Helper function to compute the Frobenius norm 
in the functional data analysis (FDA) scenario.
}
\examples{
library(fda)
mat <- matrix(1:9, nrow = 3)
fbasis <- create.fourier.basis(rangeval = c(1, 32), nbasis = 3)
PM <- eval.penalty(fbasis)  
int_prod_mat_funct(mat, PM) 
                 
}
\references{
Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2019. 
\emph{Physica A: Statistical Mechanics and its Applications} \bold{519}, 195-208. 
\url{https://doi.org/10.1016/j.physa.2018.12.036}
}
\author{
Irene Epifanio
}
