% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_S_Star_Plus_MethodB.R
\name{est_S_Star_Plus_MethodB}
\alias{est_S_Star_Plus_MethodB}
\title{Estimate the treatment effects for population S_*+ using Method B}
\usage{
est_S_Star_Plus_MethodB(X, A, Z, Y, TRT)
}
\arguments{
\item{X}{Matrix of baseline variables. Each row contains the baseline values
for each patient across multiple time points.}

\item{A}{Matrix of indicator for adherence. Each row  of A contains the
adherence information for each patient. Each column contains the adherence
indicator after each intermediate time point. A = 1 means adherence and A=0
means non-adherence. Monotone missing is assumed.}

\item{Z}{List of matrices. Intermediate efficacy and safety outcomes that can
affect the probability of adherence. For each matrix, the structure is the
same as variable X.}

\item{Y}{Numeric vector of the final outcome (E.g., primary endpoint).}

\item{TRT}{Numeric vector of treatment assignment. TRT=0 for the control
group and TRT =1 for the experimental treatment group.}
}
\value{
A list containing the following components:
  \item{trt_diff}{Estimate of treatment difference for S_{*+} using Method B}
  \item{se}{Estimated standard error}
  \item{res1}{Estimated mean for the treatment group}
  \item{res0}{Estimated mean for the control group}
  \item{se_res1}{Estimated standard error for the treatment group}
  \item{se_res0}{Estimated standard error for the control group}

#' @details
The average treatment difference can be denoted as

\deqn{latex}{\mu_{d,*+} = E\{Y(1)-Y(0)|A(1) = 1\}}

The method B exploits the joint distribution of X, Z, and A to estimate the
probability that a patient would adhere to the hypothetical alternative
treatment, and then use IPW to estimate treatment different for a given
population. The variance estimation for the treatment effect is constructed
using the sandwich method. Details can be found in the references.

The intermediate post-baseline measurements for each intermediate time point
are estimated by regressing Z on X using subjects with experimental treatment
or placebo. The covariance matrix is estimated based on the residuals of
the regression.

The probability of adherence is estimated by
regressing A on X, Z by using all data. The logistic regression is used in
this function.

The indicator of adherence prior to the first intermediate time point is not
included in this model since this function assumes no intercurrent events
prior to the first time point. Thus,  the first element of Z should not have
missing values.

Each element of Z contains the variables at each intermediate time point,
i.e., the first element of Z contains the intermediate variables at time
point 1, the second element contains the intermediate variables at time point
 2, etc.
}
\description{
The est_S_Star_Plus_MethodB function produces estimation of treatment
 effects for the population that can adhere to the experimental
 treatment (S_*+). This method (Method B) is based on the potential outcome
 under the hypothetical alternative treatment .
}
\examples{
 library(MASS)
 j<- 500
 p_z <- 6 ## dimension of Z at each time point
 n_t <- 4 ## number of time points
 alphas <- list()
 gammas <- list()
 z_para <- c(-1/p_z, -1/p_z, -1/p_z, -1/p_z, -0.5/p_z,-0.5/p_z, -0.5/p_z,
 -0.5/p_z)
 Z <- list()
 beta = c(0.2, -0.3, -0.01, 0.02, 0.03, 0.04, rep(rep(0.02,p_z), n_t))
 beta_T = -0.2
 sd_z_x = 0.4
 X = mvrnorm(j, mu=c(1,5,6,7,8), Sigma=diag(1,5))
 TRT = rbinom(j, size = 1,  prob = 0.5)
 Y_constant <- beta[1]+(X\%*\%beta[2:6])
 Y0 <- 0
 Y1 <- 0
 A <- A1 <- A0 <- matrix(NA, nrow = j, ncol = n_t)
 gamma <- c(1,-.1,-0.05,0.05,0.05,.05)
 A0[,1] <- rbinom(j, size = 1, prob = 1/(1+exp(-(gamma[1] +
 (X \%*\% gamma[2:6])))))
 A1[,1] <- rbinom(j, size = 1, prob = 1/(1+exp(-(gamma[1] +
 (X \%*\% gamma[2:6])))))
 A[,1] <- A1[,1]*TRT + A0[,1]*(1-TRT)
 for(i in 2:n_t){
   alphas[[i]] <- matrix(rep(c(2.3, -0.3, -0.01, 0.02, 0.03, 0.04, -0.4),
   p_z),ncol=p_z)
   gammas[[i]] <- c(1, -0.1, 0.2, 0.2, 0.2, 0.2, rep(z_para[i],p_z))
   Z0 <- alphas[[i]][1,]+(X\%*\%alphas[[i]][2:6,]) + mvrnorm(j, mu = rep(0,p_z)
   , Sigma = diag(sd_z_x,p_z))
   Z1 <- alphas[[i]][1,]+(X\%*\%alphas[[i]][2:6,])+alphas[[i]][7,] +
     mvrnorm(j, mu = rep(0,p_z), Sigma = diag(sd_z_x,p_z))
   Z[[i]] <- Z1*TRT + Z0*(1-TRT)
   Y0 <- (Y0 + Z0 \%*\% matrix(beta[ (7 + (i-1)*p_z):
   (6+p_z*i)],ncol = 1) )[,1]
   Y1 <- (Y1 + Z1 \%*\% matrix(beta[ (7 + (i-1)*p_z):
   (6+p_z*i)],ncol = 1) )[,1]
   A0[,i] <- rbinom(j, size = 1,
                    prob = 1/(1+exp(-(gammas[[i]][1]+
                    (X\%*\%gammas[[i]][2:6])+Z0\%*\%matrix(gammas[[i]][7:
                    (7+p_z-1)], ncol=1))[,1])))*A0[,i-1]
   A1[,i] <- rbinom(j, size = 1,
                    prob = 1/(1+exp(-(gammas[[i]][1]+
                    (X\%*\%gammas[[i]][2:6])+Z1\%*\%matrix(gammas[[i]][7:
                    (7+p_z-1)], ncol=1))[,1])))*A1[,i-1]

   A[,i] <- A1[,i]*TRT + A0[,i]*(1-TRT)
 }
 Y0 <- Y0 + rnorm(j, mean = 0, sd = 0.3) + Y_constant
 Y1 <- Y1 + + beta_T + rnorm(j, mean = 0, sd = 0.3) + Y_constant
 Y <- as.vector( Y1*TRT+Y0*(1-TRT))
 for(i in 2:n_t){
   Z[[i]][A[,(i-1)]==0,] <- NA
 }
 Z[[1]] <- matrix(NA, nrow=nrow(Z1),ncol=ncol(Z1))
 Y[A[,n_t] == 0] <- NA
 # estimate the treatment difference
 fit <- est_S_Star_Plus_MethodA(X, A, Z, Y, TRT)
 fit
 # Calculate the true values
 true1 <- mean(Y1[A1[,n_t]==1])
 true1
 true0 <- mean(Y0[A1[,n_t]==1])
 true0
 true_d  =  true1 - true0
 true_d

}
\references{
Qu, Yongming, et al. "A general framework for treatment effect estimators
considering patient adherence." Statistics in Biopharmaceutical Research
12.1 (2020): 1-18.

Zhang, Ying, et al. "Statistical inference on the estimators of the adherer
average causal effect."
Statistics in Biopharmaceutical Research (2021): 1-4.
}
