% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acfinter.R
\name{acfinter}
\alias{acfinter}
\title{ACF and PACF Analysis with Interactive Features}
\usage{
acfinter(
  datag,
  lag = 72,
  ci.method = "white",
  ci = 0.95,
  interactive = NULL,
  delta = "levels",
  download = FALSE
)
}
\arguments{
\item{datag}{A numeric vector or a time series object.}

\item{lag}{Maximum number of lags for the ACF and PACF. Default is 72.}

\item{ci.method}{Method for confidence intervals: "white" (default) or "ma".}

\item{ci}{Confidence level for confidence intervals. Default is 0.95.}

\item{interactive}{Character string specifying whether to create an interactive table:
"acftable" for the ACF-PACF table, "stattable" for the stationarity tests table. Default is NULL.}

\item{delta}{Transformation of the data: "levels" (default), "diff1", "diff2", or "diff3".}

\item{download}{Logical indicating whether to save the results as files. Default is FALSE.}
}
\value{
A list with two elements: "ACF-PACF Test" and "Stationary Test".
The function also creates interactive plots and tables if specified.
}
\description{
acfinter computes and visualizes the ACF and PACF of a given time series,
performs stationarity tests, and optionally generates interactive tables and plots.
}
\examples{
data <- actfts::GDPEEUU
result <- actfts::acfinter(data, lag = 20, ci.method = "white", interactive = "acftable")
print(result)

}
