% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acled_auth.R
\name{acled_auth}
\alias{acled_auth}
\title{Authenticate a request via ACLED API OAuth endpoint.}
\usage{
acled_auth(req, username, password = NULL)
}
\arguments{
\item{req}{An ACLED API request.}

\item{username}{Email associated with ACLED account.}

\item{password}{User password associated with ACLED account.}
}
\value{
Returns a modified HTTP request that will use OAuth for the ACLED API.
}
\description{
Pings the ACLED API token endpoint for authentication using email and password.
}
\examples{
\dontrun{
acled_auth(req, email, password)
}
}
\seealso{
ACLED API Access guide \url{https://acleddata.com/api-documentation/getting-started}

Other API and Access: 
\code{\link{acled_api}()},
\code{\link{acled_deletions_api}()},
\code{\link{acled_update}()}
}
\concept{API and Access}
