% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrual_table.R
\name{accrual_table}
\alias{accrual_table}
\title{accrual_table}
\usage{
accrual_table(
  accrual_df,
  overall = TRUE,
  name_overall = "Overall",
  pos_overall = c("last", "first"),
  unit = c("month", "year", "week", "day"),
  format_table_date = "\%d\%b\%Y",
  format_time = "\%1.0f",
  format_rrate = "\%1.2f",
  header = TRUE
)
}
\arguments{
\item{accrual_df}{object of class 'accrual_df' or 'accrual_list' produced by \code{accrual_create_df}.}

\item{overall}{logical, indicates that accrual_df contains a summary with all sites (only if by is not NA).}

\item{name_overall}{name of the summary with all sites (if by is not NA and overall==TRUE).}

\item{pos_overall}{overall in last or first row (if by is not NA and overall==TRUE).}

\item{unit}{time unit for time recruiting and the rate,
one of \code{"month"}, \code{"year"}, \code{"week"} or \code{"day"}.}

\item{format_table_date}{format of start date in table.}

\item{format_time}{format of time recruiting in table.}

\item{format_rrate}{format of recruitment rate in table.}

\item{header}{include header, logical or character vector of length 4 or 5 (if accrual_df is a list).}
}
\value{
Returns data frame with a header, a row per site and overall and the following columns:
\item{name}{name of the site (if accrual_df is a list)}
\item{start_date}{accrual start date}
\item{time}{time accruing}
\item{n}{number of patients accrued}
\item{rate}{accrual rate per time unit}
}
\description{
Table of recruitment overview by site,
rate of recruitment
}
\examples{
data(accrualdemo)
accrual_df<-accrual_create_df(accrualdemo$date,by=accrualdemo$site)
accrual_table(accrual_df)

#format
accrual_table(accrual_df,format_time="\%1.1f",format_rrate="\%1.1f")

#unit
accrual_table(accrual_df,unit="day")

#common start and current dates
accrual_df<-accrual_create_df(accrualdemo$date,by=accrualdemo$site,start_date="common",
current_date="common")
accrual_table(accrual_df)
accrual_df<-accrual_create_df(accrualdemo$date,by=accrualdemo$site,start_date=as.Date("2020-07-09"),
    current_date=as.Date("2020-10-15"))
accrual_table(accrual_df)


}
