% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-settings.R
\name{set_openai_api_key}
\alias{set_openai_api_key}
\title{Set OpenAI API key}
\usage{
set_openai_api_key(key, overwrite = FALSE, temporary = FALSE)
}
\arguments{
\item{key}{an OpenAI API key. For more information on keys see the \href{https://openai.com/blog/openai-api}{OpenAI API blog}}

\item{overwrite}{Option to overwrite any existing OpenAI keys already stored locally.}

\item{temporary}{Option to not store thew API key for use across sessions.}
}
\description{
NLP functionalities require a paid OpenAI API key to communicate with Open AI models.
}
\examples{
\dontrun{
set_openai_api_key("YOUR_OPENAI_API_KEY")

# This will set the key permanently until overwritten again
set_openai_api_key("YOUR_OPENAI_API_KEY")
}
}
