### f function for computing the minimum possible Ansari-Bradley test statistic
f <- function(X,Y_prime,m, k){
  n <- length(X)
  m_prime <- length(Y_prime)
  Z_prime = c(X,Y_prime)
  N_prime = (n + m_prime + 1)/2
  c = k - (m - m_prime)/2
  a = min(0,c)
  b = max(0,c)
  sgn_c = 2*(c>0) - 1
  PartialRankX <- rank(c(X,Y_prime))[1:n]
  sum_A <- sum(PartialRankX < (N_prime + a))
  sum_C <- sum(PartialRankX > (N_prime + b))
  B <- PartialRankX[(PartialRankX >= N_prime + a)&(PartialRankX <= N_prime + b)]
  res <- (sum_A - sum_C)*c + sgn_c*sum( 2*N_prime + c - 2*B )
  return(res)
}
