% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.graph.R
\name{generate.bmn.data}
\alias{generate.bmn.data}
\title{Generate a dataset from binary markov network}
\usage{
generate.bmn.data(
  n,
  p,
  type = 1,
  seed = NULL,
  graph.seed = NULL,
  theta = NULL,
  beta = 0.7,
  degree = 3,
  alpha = 0.4,
  method = "freq"
)
}
\arguments{
\item{n}{The number of observations.}

\item{p}{The number of predictors of interest.}

\item{type}{a numeric value that indicates the type of an interaction matrix}

\item{seed}{Seed to be used to reproduce dataset}

\item{graph.seed}{Seed used to reproduce the interaction matrix}

\item{theta}{An user specified interaction matrix. It should be a symmetric matrix.}

\item{beta}{a numeric value that specifies the remaining signal of the interaction matrix}

\item{degree}{an integer value that specifies the maximum node degree in the interaction matrix}

\item{alpha}{a numeric value that specifies the minimum signal of the interaction matrix}

\item{method}{the method used for generating samples. One is the "freq", another is it "gibbs". The former is more suitable when p<18, while the later is more suitable when p > 18.}
}
\value{
a list that includes three components: data, weight, theta. data is an n-by-p matrix that record samples; weight: an n-dimensional vector that records the frequency of each row of data; theta is the interaction matrix used for generating samples.
}
\description{
Generate a dataset with binary variables upon the interaction matrix. If the interaction matrix is not provided, and then, an interaction matrix would be generated.
}
\examples{
library(abess)
p <- 16
n <- 1e3
train <- generate.bmn.data(n, p, type = 7, graph.seed = 1, seed = 1, beta = 1.3, alpha = 0.2)
res <- slide(train[["data"]], train[["weight"]], tune.type = "gic")
}
