% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{correlation_distance}
\alias{correlation_distance}
\alias{cosine_distance}
\title{Correlation and cosine distance}
\usage{
correlation_distance(x, y)

cosine_distance(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The correlation or cosine distance. These are undefined if either
  \code{x} or \code{y} contain all zero elements, that is, if \eqn{|x| = 0}
  or \eqn{|y| = 0}. In this case, we return \code{NaN}.
}
\description{
The correlation and cosine distances, which are derived from the dot
product of the two vectors.
}
\details{
For vectors \code{x} and \code{y}, the cosine distance is defined as the
cosine of the angle between the vectors,
\deqn{d(x, y) = 1 - \frac{x \cdot y}{|x| |y|},} where \eqn{|x|} is the
magnitude or L2 norm of the vector, \eqn{|x| = \sqrt{\sum_i x_i^2}}.
Relation to other definitions:
\itemize{
  \item Equivalent to the \code{cosine()} function in
    \code{scipy.spatial.distance}.
}

The correlation distance is simply equal to one minus the Pearson
correlation between vectors. Mathematically, it is equivalent to the cosine
distance between the vectors after they are centered (\eqn{x - \bar{x}}).
Relation to other definitions:
\itemize{
  \item Equivalent to the \code{correlation()} function in
    \code{scipy.spatial.distance}.
  \item Equivalent to the \code{1 - mempearson} calculator in Mothur.
}
}
\examples{
x <- c(2, 0)
y <- c(5, 5)
cosine_distance(x, y)
# The two vectors form a 45 degree angle, or pi / 4
1 - cos(pi / 4)

v <- c(3.5, 0.1, 1.4)
w <- c(3.3, 0.5, 0.9)
correlation_distance(v, w)
1 - cor(v, w)
}
