% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{canberra}
\alias{canberra}
\alias{clark_coefficient_of_divergence}
\title{Canberra and related distances}
\usage{
canberra(x, y)

clark_coefficient_of_divergence(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The Canberra distance or Clark's coefficient of divergence. If every
  element in \code{x} and \code{y} is zero, Clark's coefficient of
  divergence is undefined, and we return \code{NaN}.
}
\description{
The Canberra distance and Clark's coefficient of divergence are measures
that use the absolute difference over the sum for each element of the
vectors.
}
\details{
For vectors \code{x} and \code{y}, the Canberra distance is defined as
\deqn{d(x, y) = \sum_i \frac{|x_i - y_i|}{x_i + y_i}.} Elements where
\eqn{x_i + y_i = 0} are not included in the sum. Relation of
\code{canberra()} to other definitions:
\itemize{
  \item Equivalent to R's built-in \code{dist()} function with
    \code{method = "canberra"}.
  \item Equivalent to the \code{vegdist()} function with
    \code{method = "canberra"}, multiplied by the number of entries where
    \code{x > 0}, \code{y > 0}, or both.
  \item Equivalent to the \code{canberra()} function in
    \code{scipy.spatial.distance} for positive vectors. They take the
    absolute value of \eqn{x_i} and \eqn{y_i} in the denominator.
  \item Equivalent to the \code{canberra} calculator in Mothur, multiplied
    by the total number of species in \code{x} and \code{y}.
  \item Equivalent to \eqn{D_{10}} in Legendre & Legendre.
}

Clark's coefficient of divergence involves summing squares and taking a
square root afterwards:
\deqn{
  d(x, y) = \sqrt{
    \frac{1}{n} \sum_i \left( \frac{x_i - y_i}{x_i + y_i} \right)^2
  },}
where \eqn{n} is the number of elements where \code{x > 0}, \code{y > 0}, or
both. Relation of \code{clark_coefficient_of_divergence()} to other
definitions:
\itemize{
  \item Equivalent to \eqn{D_{11}}{D_11} in Legendre & Legendre.
}
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
y <- c(10, 2, 0, 1, 1, 0)
canberra(x, y)
clark_coefficient_of_divergence(x, y)
}
