% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZetaSuiteApp.R
\name{ZetaSuiteApp}
\alias{ZetaSuiteApp}
\title{Launch ZetaSuite Shiny Application}
\usage{
ZetaSuiteApp(launch.browser = TRUE, port = NULL, host = "127.0.0.1")
}
\arguments{
\item{launch.browser}{Logical. Should the app launch in the default browser?
Default is TRUE.}

\item{port}{Integer. Port number for the Shiny app. Default is NULL (random port).}

\item{host}{Character. Host address. Default is "127.0.0.1" (localhost).}
}
\value{
Launches the Shiny application in a web browser.
}
\description{
Launches the ZetaSuite Shiny web application for interactive analysis of 
high-throughput screening data and single-cell RNA-seq quality control.
}
\details{
The Shiny app provides a user-friendly interface for:
\itemize{
  \item Quality Control Analysis
  \item Z-score Normalization
  \item Event Coverage Analysis
  \item Zeta Score Calculation
  \item SVM-based Background Correction
  \item Screen Strength Analysis
  \item Single Cell Quality Control
  \item Interactive visualizations and data export
}
}
\examples{
\dontrun{
# Launch the ZetaSuite Shiny app
ZetaSuiteApp()

# Launch without opening browser automatically
ZetaSuiteApp(launch.browser = FALSE)

# Launch on a specific port
ZetaSuiteApp(port = 3838)
}

}
