% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_med.r
\name{read_med}
\alias{read_med}
\title{Process MED to csv based on standard data structure event.time}
\usage{
read_med(
  fname,
  save_file = FALSE,
  path_save = NULL,
  col_r = "C:",
  col_names = c("time", "event"),
  out = TRUE,
  num_col = 6,
  time_dot_event = TRUE,
  ...
)
}
\arguments{
\item{fname}{chr, the name of a MED file to read; can include the directory}

\item{save_file}{logical, save csv on the disk? TRUE or FALSE (default)}

\item{path_save}{chr, directory to save csv files if save_file is TRUE;}

\item{col_r}{chr, MED array to read (may be an event.time variable; see Details)}

\item{col_names}{chr, a vector of column names}

\item{out}{logical, if true returns the data.frame of n x 2}

\item{num_col}{int, corresponds to DISKCOLUMNS of MED}

\item{time_dot_event}{logical, if true, assumes that array to process has a time.event format}

\item{...}{other arguments passed to \code{\link{read.table}}}
}
\value{
if out is true, returns a data.frame; if save_file is TRUE, writes the data.frame in csv format at path_save
}
\description{
Process MED to csv based on standard data structure event.time
}
\details{
The default behavior of this function has time_dot_event = TRUE,
which means that the raw MED can be should be in time.event convention.
For example, if a response is coded as 23, the time is in 1/100 seconds and a response
occurred at 2 minutes, the event is saved in, say, column C as 6000.23. This will be
processed as
time event
6000  23

However, if time_dot_event = FALSE, the output will be a data.frame with one column
values. For example
values
6000.23
}
\examples{
# read raw data from MED
data("fi60_raw_from_med")
# see first 10 lines
head(fi60_raw_from_med, 10)
# create a temporary file to avoid non-staged installation warning
temp_file <- tempfile(fileext = ".txt")
# write the data to the temporary file
writeLines(fi60_raw_from_med, temp_file)
# Use the temporary file for processing
fi60_processed <- read_med(fname = temp_file, save_file = FALSE,
  col_r = "C:", out = TRUE,
  col_names = c("time", "event"), num_col = 6, time_dot_event = TRUE)
head(fi60_processed)
# __________________________________________________________________________
## To use in bulk
# 1) Generate a list of filenames of raw MED data
# 2) Loop over the list with the function, using each element
#    of the list as the fname argument.
# __________________________________________________________________________
# Suppose all raw MED files start with 2020, and you are in the working directory
# If all the raw MED files are in the wd, we can directly get the filenames
# with unspecified path
# filenames <- list.files(pattern = "^2020")
# The above line will look in the wd for all the files starting with "2020"
# and it will save it as a vector of strings in "filenames".
# With that vector, make a for loop like the following:
# __________________________________________________________________________
# If you want to work immediately with the processed data, first create an empty
# dataframe to store the data file per file
# df_working = data.frame()
# __________________________________________________________________________
# for (f in filenames) {
#   df_tmp <- read_med(fname = f,
#                     path_save = "data/processed/", # put here your path to save the csv
#                     col_r = 'C:', # if the time.event vector is saved in variable C
#                     out = TRUE ) # If you want to store processed data in df_tmp,
# otherwise write out = FALSE
# now append at rows the new data.frame
#   df_working = rbind(df_working, df_tmp)
# }
# Thats all.

}
