% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_fi.r
\name{exhaustive_sbp}
\alias{exhaustive_sbp}
\title{Single breakpoint algorithm, the exhaustive version as the one used in Guilhardi & Church 2004}
\usage{
exhaustive_sbp(r_times, trial_duration)
}
\arguments{
\item{r_times}{numeric, the times at which a response was emitted in a trial}

\item{trial_duration}{numeric, the duration of the IF interval}
}
\value{
A data frame of 3 columns
\code{bp} a numeric value which corresponds to the time at which a break point was detected
\code{r1} a numeric value of the response rate \emph{before} the breakpoint
\code{r2} a numeric value of the responser rate \emph{after} the breakpoint
\code{d1} a numeric value of the duration of the first state
\code{d2} a numeric value of the duration of the second state
}
\description{
Single breakpoint algorithm, the exhaustive version as the one used in Guilhardi & Church 2004
}
\details{
This algorithm performs an extensive search of every combination (t1, t2)
where t1 starts in the first response through (length(r_times) - 1)
}
\examples{
data("r_times")
r_times <- r_times[r_times < 60]
single_bp <- exhaustive_sbp(r_times, 60)

plot(r_times, seq_along(r_times),
  xlim = c(0, max(r_times)),
  main = "Cummulative Record",
  xlab = "Time (s)",
  ylab = "Cum Resp",
  col = 2, type = "s"
)
abline(v = single_bp$bp)

bp_from_opt <- bp_opt(r_times, 60)
abline(v = bp_from_opt$bp, col = 3)
}
