% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveletRF.R
\name{WaveletFittingRF}
\alias{WaveletFittingRF}
\title{Wavelet-RF Hybrid Model for Forecasting}
\usage{
WaveletFittingRF(
  ts,
  tlag = ACF,
  Waveletlevels,
  WaveletFilter = "haar",
  boundary = "periodic",
  FastFlag = TRUE,
  SplitRatio = 0.8
)
}
\arguments{
\item{ts}{Univariate time series}

\item{tlag}{Number of lags}

\item{Waveletlevels}{The level of wavelet decomposition}

\item{WaveletFilter}{Wavelet filter use in the decomposition}

\item{boundary}{The boundary condition of wavelet decomposition}

\item{FastFlag}{The FastFlag condition of wavelet decomposition: True or False}

\item{SplitRatio}{Training and testing data split}
}
\value{
\itemize{
  \item TrainFittedValue - Fitted value of train data
  \item TestPredictedValue - Predicted value of test data
  \item AccuracyTable - RMSE and MAPE of train and test data
}
}
\description{
The Wavelet Decomposition followed by Random Forest Regression (RF) models have been applied for time series forecasting. The maximum overlap discrete wavelet transform (MODWT) algorithm was chosen as it works for any length of the series. The series is first divided into training and testing sets. In each of the wavelet decomposed series, the  supervised machine learning approach namely random forest was employed to train the model. This package also provides accuracy metrics in the form of Root Mean Square Error (RMSE) and Mean Absolute Prediction Error (MAPE).
}
\examples{
data<-rnorm(200,mean=20,sd=3)
WRF<-WaveletFittingRF(ts=data,tlag=2,Waveletlevels=3)
}
\references{
\itemize{
\item Ding, Y., Zhang, W., Zhao, X., Zhang, L. and Yan, F., 2020. A hybrid random forest method fusing wavelet transform and variable importance for the quantitative analysis of K in potassic salt ore using laser-induced breakdown spectroscopy. Journal of Analytical Atomic Spectrometry, 35(6), 1131-1138.
\item Rezaali, M., Fouladi-Fard, R., Mojarad, H., Sorooshian, A., Mahdinia, M. and Mirzaei, N., 2021. A wavelet-based random forest approach for indoor BTEX spatiotemporal modeling and health risk assessment. Environmental Science and Pollution Research, 28(18), 22522-22535.
\item Paul, R. K., Prajneshu and Ghosh H. 2013. Wavelet Frequency Domain Approach for Modelling and Forecasting of Indian Monsoon Rainfall Time-Series Data. Journal of the Indian society of agricultural statistics, 67, 319-327.
\item Paul, R. K. and Birthal, P.S. 2015. Investigating rainfall trend over India using wavelet technique. Journal of Water and Climate Change, 7, 365 to 378.
\item Paul, R. K. 2015. ARIMAX-GARCH-WAVELET Model for forecasting volatile data. Model Assisted Statistics and Application, 10, 243 to 252.
}
}
