% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WOTPLY.R
\name{WOTPLY}
\alias{WOTPLY}
\title{WOTPLY}
\usage{
WOTPLY(
  list_transition_matrices,
  selected_stages,
  cluster_label,
  legend_time,
  customize_color,
  top_link = NULL
)
}
\arguments{
\item{list_transition_matrices}{List of transition matrices. Each matrix contains the transition probabilitiesfrom the clusters at time t (on the columns) towards the clusters at time t+1 (on the rows).
The matrices can be obtain from function \emph{get_transition_matrix}}

\item{selected_stages}{Vector with the name of the clusters related to the latest time point
for which we want to know the connection to clusters at previous time points.}

\item{cluster_label}{Vector with the cluster information for all the cells from all time points.}

\item{legend_time}{Vector with time information with length equal to the number of time points.}

\item{customize_color}{Character vector with the name of the colour for each cluster (node) in each time point.}

\item{top_link}{Integer.Maximum number of links to select between clusters at time t and clusters at time t+1. Links are sorted according to the weight and then only the \emph{top_link} are kept. If \emph{NULL} (default), all the links are kept.}
}
\value{
A ggnet2 plot
}
\description{
A ggnet2 plot is generated showing the connections between \emph{selected_stages} from the latest time point and the clusters from previous time points . The number of columns is equal to the numbers of time points. In each column, the cluster of the
corresponding time point is shown as network node. The weight of the links between clusters at time points t and t+1 reflect the weight of the
transition probabilities from \emph{list_transition_matrices}.
}
\examples{
\donttest{transition_1 <- matrix(1,ncol = 2,nrow = 2)
colnames(transition_1) <- c("Stage1", "Stage2")
row.names(transition_1) <- c("Stage1", "Stage2")
l_t <- list((transition_1))
selected_stages <- c("Stage1")
cluster_label <- c("Stage1", "Stage2")
legend_time <- c("Day1", "Day2")
customize_color <- c("#F8766D", "#00BFC4")
WOTPLY(l_t, selected_stages, cluster_label, legend_time, customize_color)
}

}
\seealso{
\url{https://CRAN.R-project.org/package=GGally}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
