% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galaxy.R
\name{show_galaxy_footer}
\alias{show_galaxy_footer}
\title{show_galaxy_footer - shows the footer for glaxy tools}
\usage{
show_galaxy_footer(
  tool_name,
  tool_version,
  logger = NULL,
  show_packages = TRUE,
  ellapsed = NULL
)
}
\arguments{
\item{tool_name}{a \code{character(1)} holding the
running tool's name.}

\item{tool_version}{a \code{character(1)} holding the
running tool's version.}

\item{logger}{a \code{get_logger("name")} instance - if provided, the
galaxy footer if output from the logger.}

\item{show_packages}{logical - Tells whether to display loaded packages
and attached packages.}

\item{ellapsed}{NULL or a \code{character(1)} with execution duration.}
}
\value{
\code{NULL}
}
\description{
This function prints the footer to display in galaxy's tools logs
}
\examples{

show_galaxy_footer("Tool Name", "1.2.0")

show_galaxy_footer(
  tool_name = "Tool Name",
  tool_version = "1.2.0",
  logger = get_logger("Some Tool"),
  show_packages = FALSE,
  ellapsed = "14.5 seconds"
)

}
\seealso{
\link{run_galaxy_processing}
}
\author{
L.Pavot
}
