% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surClaytonCopula.R
\name{surClaytonCopula}
\alias{surClaytonCopula}
\alias{r90ClaytonCopula}
\alias{r270ClaytonCopula}
\title{Constructors for survival and rotated Clayton Copulas}
\usage{
surClaytonCopula(param = 1)

r90ClaytonCopula(param = -1)

r270ClaytonCopula(param = -1)
}
\arguments{
\item{param}{A single parameter defining the Copula.}
}
\value{
An object of class \linkS4class{surClaytonCopula},
\linkS4class{r90ClaytonCopula} or
\linkS4class{r270ClaytonCopula} respectively.
}
\description{
These are wrappers to functions from \link[VineCopula:VineCopula-package]{VineCopula::VineCopula-package}
}
\examples{

library(copula)

persp(surClaytonCopula(1.5), dCopula, zlim = c(0, 10))
persp(r90ClaytonCopula(-1.5), dCopula, zlim = c(0, 10))
persp(r270ClaytonCopula(-1.5), dCopula, zlim = c(0, 10))
}
\keyword{copula}
