% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VBV.R
\name{estimation}
\alias{estimation}
\title{estimation -- estimate trend and seasonal components statically}
\usage{
estimation(t.vec, y.vec, p, q.vec, base.period, lambda1, lambda2)
}
\arguments{
\item{t.vec}{vector of points in time as integers}

\item{y.vec}{vector of data}

\item{p}{maximum exponent in polynomial for trend}

\item{q.vec}{vector containing frequencies to use for seasonal component, given as integers, i.e. c(1, 3, 5) for 1/2\emph{pi, 3/2}pi, 5/2*pi (times length of base period)}

\item{base.period}{base period in number of observations, i.e. 12 for monthly data with yearly oscillations}

\item{lambda1}{penalty weight for smoothness of trend}

\item{lambda2}{penalty weight for smoothness of seasonal component (lambda1 == lambda2 == Inf result in estimations of the original Berliner Verfahren)}
}
\value{
A dataframe with the following components:
\itemize{
\item{data}{original data y.vec}
\item{trend}{vector of estimated trend of length length(y.vec)}
\item{season}{vector of estimated season of length length(y.vec)}
}
}
\description{
estimation -- estimate trend and seasonal components statically
}
\examples{
### using of estimation

t <- 1:121 # equidistant time points, i.e. 5 days
y <- 0.1*t + sin(t) + rnorm(length(t))

p <- 2     # maximally quadratic
q <- c(1, 3, 5)   # 'seasonal' components within the base period
base.period <- 24 # i.e. hourly data with daily cycles
l1 <- 1    
l2 <- 10

est <- estimation( t, y, p, q, base.period, l1, l2)
plot(est$data)
lines(est$trend + est$season)
}
