% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_full_Bayes_SR.R
\name{lm_full_Bayes_SR}
\alias{lm_full_Bayes_SR}
\title{Full Bayesian Shrinkage Estimation Method for Multivariate Regression}
\usage{
lm_full_Bayes_SR(Y, X, dof = Inf, burnincycle = 1000, mcmccycle = 2000)
}
\arguments{
\item{Y}{An N x K matrix of dependent variables.}

\item{X}{An N x M matrix of regressors.}

\item{dof}{Degree of freedom for multivariate t-distribution.
If \code{dof = Inf} (default), then multivariate normal distribution is
applied and weight vector q is not estimated. If \code{dof = NULL} or
\code{dof} <= 0, then \code{dof} and q are estimated automatically.
If \code{dof} is a positive number, q is estimated.}

\item{burnincycle, mcmccycle}{Number of burnin cycles is the number of
initially generated sample values to drop. Number of MCMC cycles is the
number of generated sample values to compute estimates.}
}
\value{
A list object with estimated parameters: Psi, Sigma, dof, delta
(delta is the reciprocal of lambda), and lambda.
Additional components are se.param (standard error of the parameters) and
LINEXVARmodel (estimates under LINEX loss).
}
\description{
Estimate regression coefficients and scale matrix for noise by using
Gibbs MCMC algorithm. The function assumes 1) multivariate t-distribution
for noise as a sampling distribution, and 2) noninformative priors for
regression coefficients and scale matrix for noise.
}
\details{
Consider the multivariate regression:
\deqn{Y = X \Psi + e, \quad e \sim MVT(0, \nu, \Sigma).}
\eqn{\Psi} is a M-by-K matrix of regression coefficients and
\eqn{\Sigma} is a K-by-K scale matrix for multivariate t-distribution for
noise.

Sampling distribution for noise e is multivariate t-distribution with
degree of freedom dof and scale matrix \eqn{\Sigma: e \sim MVT(0, \nu,
\Sigma)}.
The priors are noninformative priors: 1) the shrinkage prior for regression
coefficients \eqn{\Psi}, and 2) the reference prior for scale matrix
\eqn{\Sigma}.

The function implements Gibbs MCMC algorithm for estimating regression
coefficients Psi and scale matrix Sigma.
}
\references{
S. Ni and D. Sun (2005). Bayesian estimates for vector
autoregressive models. Journal of Business & Economic Statistics 23(1),
105-117.
}
