% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{cvVAR}
\alias{cvVAR}
\title{Cross-Validated VAR Estimation using Elastic Net}
\usage{
cvVAR(data, p, opt = NULL)
}
\arguments{
\item{data}{A numeric matrix with time series data (observations in rows, variables in columns).}

\item{p}{Integer. The order of the VAR model.}

\item{opt}{List. A list of options (see \code{fitVAR} for details).}
}
\value{
A list with components:
\item{mu}{Vector of means of the original series.}
\item{A}{List of VAR coefficient matrices (one for each lag).}
\item{fit}{The complete elastic net CV fit (if requested).}
\item{lambda}{The optimal lambda value chosen by CV.}
\item{mse}{The minimum mean squared error from CV.}
\item{mse_sd}{Standard deviation of the MSE.}
\item{time}{Elapsed time for the ENET estimation.}
\item{series}{The transformed series (after centering/scaling).}
\item{residuals}{Residuals from the VAR model.}
\item{sigma}{Estimated covariance matrix of the residuals.}
}
\description{
This internal function performs cross validation for VAR estimation using the elastic net
penalty. It prepares the data, calls the elastic net CV routine, reshapes the estimated coefficients,
applies optional thresholding, computes residuals, and estimates the error covariance.
}
\keyword{internal}
