% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.to.vectors.R
\name{table.to.vectors}
\alias{table.to.vectors}
\title{Recover Raw Data Vectors from Contingency Table}
\usage{
table.to.vectors(x)
}
\arguments{
\item{x}{A numeric matrix or contingency table containing non-negative integer counts. 
Must not contain NA values.}
}
\value{
A list containing two integer vectors:
\item{x_vector}{A vector of row indices corresponding to the observations.}
\item{y_vector}{A vector of column indices corresponding to the observations.}
}
\description{
Converts a contingency table (count data) back into two vectors of raw observations. 
This is useful when you have a summary table but need to run tests that require 
raw data vectors (like the functions in this package).
}
\examples{
library("Upsilon")

# Create a sample contingency table
# Rows = Variable A (levels 1,2), Cols = Variable B (levels 1,2,3)
tab <- matrix(c(10, 5, 2, 8, 5, 10), nrow = 2, byrow = TRUE)
print(tab)

# Recover the raw vectors
res <- table.to.vectors(tab)

# Check the result
length(res$x_vector) # Should be sum(tab) = 40
head(cbind(res$x_vector, res$y_vector))
table(res$x_vector, res$y_vector) # Should as same as tab
}
\keyword{internal}
