% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unico.r
\name{tensor}
\alias{tensor}
\title{Inferring the underlying source-specific 3D tensor}
\usage{
tensor(
  X,
  W,
  C1,
  C2,
  Unico.mdl,
  parallel = TRUE,
  num_cores = NULL,
  log_file = "Unico.log",
  verbose = FALSE,
  debug = FALSE
)
}
\arguments{
\item{X}{An \code{m} by \code{n} matrix of measurements of \code{m} features for \code{n} observations. Each column in \code{X} is assumed to be a mixture of \code{k} sources. Note that \code{X} must include row names and column names and that NA values are currently not supported. \code{X} should not include features that are constant across all observations. Note that \code{X} could potentially be different from the \code{X} used to learn \code{Unico.mdl} (i.e. the original observed 2D mixture used to fit the model).}

\item{W}{An \code{n} by \code{k} matrix of weights - the weights of \code{k} sources for each of the \code{n} mixtures (observations). All the weights must be positive and each row - corresponding to the weights of a single observation - must sum up to 1. Note that \code{W} must include row names and column names and that NA values are currently not supported.}

\item{C1}{An \code{n} by \code{p1} design matrix of covariates that may affect the hidden source-specific values (possibly a different effect size in each source). Note that \code{C1} must include row names and column names and should not include an intercept term. NA values are currently not supported. Note that all covariates in \code{C1} must be present and match the order of the set of covariates in \code{C1} stored in \code{Unico.mdl} (i.e. the original set of source-specific covariates available when initially fitting the model).}

\item{C2}{An \code{n} by \code{p2} design matrix of covariates that may affect the mixture (i.e. rather than directly the sources of the mixture; for example, variables that capture biases in the collection of the measurements). Note that \code{C2} must include row names and column names and should not include an intercept term. NA values are currently not supported. Note that all covariates in \code{C2} must be present and match the order of the set of covariates in \code{C2} stored in \code{Unico.mdl} (i.e. the original set of not source-specific covariates available when initially fitting the model).}

\item{Unico.mdl}{The entire set of model parameters estimated by Unico on the 2D mixture matrix (i.e. the list returned by applying function \code{Unico} to \code{X}).}

\item{parallel}{A logical value indicating whether to use parallel computing (possible when using a multi-core machine).}

\item{num_cores}{A numeric value indicating the number of cores to use (activated only if \code{parallel == TRUE}). If \code{num_cores == NULL} then all available cores except for one will be used.}

\item{log_file}{A path to an output log file. Note that if the file \code{log_file} already exists then logs will be appended to the end of the file. Set \code{log_file} to \code{NULL} to prevent output from being saved into a file; note that if \code{verbose == FALSE} then no output file will be generated regardless of the value of \code{log_file}.}

\item{verbose}{A logical value indicating whether to print logs.}

\item{debug}{A logical value indicating whether to set the logger to a more detailed debug level; set \code{debug} to \code{TRUE} before reporting issues.}
}
\value{
A \code{k} by \code{m} by \code{n} array with the estimated source-specific values. The first axis/dimension in the array corresponds to the different sources.
}
\description{
Infers the underlying (sources by features by observations) 3D tensor from the observed (features by observations) 2D mixture, under the assumption of the Unico model that each observation is a mixture of unique source-specific values (in each feature in the data). In the context of bulk genomics containing a mixture of cell types (i.e. the input could be CpG sites by individuals for DNA methylation and genes by individuals for RNA expression), \code{tensor} allows to estimate the cell-type-specific levels for each individual in each CpG site/gene (i.e. a tensor of CpG sites/genes by individuals by cell types).
}
\details{
After obtaining all the estimated parameters in the Unico model (by calling \link{Unico}), \code{tensor} uses the conditional distribution \eqn{Z_{jh}^i|X_{ij}=x_{ij}} for estimating the \eqn{k} source-specific levels of each sample \eqn{i} at each feature \eqn{j}.
}
\examples{
data = simulate_data(n=100, m=2, k=3, p1=1, p2=1, taus_std=0, log_file=NULL)
res = list()
res$params.hat = Unico(data$X, data$W, data$C1, data$C2, parallel=FALSE, log_file=NULL)
res$Z = tensor(data$X, data$W, data$C1, data$C2, res$params.hat, parallel=FALSE, log_file=NULL)

}
