% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Mapa.R
\name{Plot.Mapa}
\alias{Plot.Mapa}
\title{Cree un widget para visualizar datos geográficos en un mapa interactivo usando
el paquete \code{Leaflet}}
\usage{
Plot.Mapa(
  datos,
  df,
  depto,
  mpio,
  variable,
  agregado = TRUE,
  zoomIslas = FALSE,
  estadistico = c("Conteo", "Promedio", "Mediana", "Varianza", "SD", "CV", "Min", "Max"),
  tipo = c("Deptos", "SiNoMpios", "Mpios", "DeptoMpio"),
  SiNoLegend,
  titulo,
  naTo0 = TRUE,
  colNA = "#EEEEEE",
  centroideMapa,
  zoomMapa = 6,
  baldosas,
  cortes,
  colores,
  showSedes = TRUE,
  colSedes,
  opacidad = 0.7,
  colBorde,
  compacto = TRUE,
  textSize = 10,
  limpio = FALSE,
  estatico = FALSE,
  estilo,
  ...
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{df}{Argument deprecated, use \code{datos} instead.}

\item{depto}{Una variable numérica dentro del data frame ingresado en \code{datos},
que contiene los códigos de los departamentos, de acuerdo con la codificación
de la División Político-Administrativa de Colombia (\emph{DIVIPOLA}) dispuesta
por el \code{DANE}.}

\item{mpio}{Una variable numérica dentro del data frame ingresado en \code{datos},
que contiene los códigos de los municipios, de acuerdo con la codificación
de la División Político-Administrativa de Colombia (\emph{DIVIPOLA}) dispuesta
por el \code{DANE}.}

\item{variable}{Variable auxiliar con la cual se calculará el estadístico
previamente seleccionado. Para el caso en que la estadística a calcular sea
el conteo no es necesario (\emph{no se usará}) especificar dicha variable numérica.}

\item{agregado}{Si es \code{TRUE} (\emph{valor predeterminado}) indica que el data frame
ingresado se deberá agrupar porque no es un consolidado, sino que se cuenta
con los microdatos. Por el contrario, si se especifica en \code{FALSE} quiere
decir que cada fila es única y se cuenta con el estadístico ya calculado,
además de poder ingresar únicamente uno de los argumentos \code{depto} o \code{mpio}.}

\item{zoomIslas}{Valor booleano que indica si desea realizar un zoom al
archipiélago de San Andrés, Providencia y Santa catalina. El valor a retornar
no será un único plot sino una lista compuesta por dos figuras, una para el
mapa sin las islas y otro únicamente con ellas, para que usted realice
posteriormente la unión de ambos. Aplica únicamente para el caso estático y
su valor por defecto es \code{FALSE}.}

\item{estadistico}{Cadena de caracteres que indica el estadístico a graficar
en el mapa. Los valores permitidos son \code{"Conteo"} (\emph{valor predeterminado}),
\code{"Promedio"}, \code{"Mediana"}, \code{"Varianza"}, \code{"SD"}, \code{"CV"}, \code{"Min"} y \code{"Max"}.}

\item{tipo}{Cadena de caracteres que indica el tipo de mapa a graficar. Los
valores permitidos son "Deptos", "SiNoMpios", "Mpios" y "DeptoMpio"
(\emph{valor predeterminado}). Se emparejará parcialmente.}

\item{SiNoLegend}{Vector de caracteres de longitud 2 que permite editar las
opciones de la etiqueta de la leyenda de los mapas \code{"SiNoMpios"}. El valor
por defecto es \verb{("0", "1 o más")}.}

\item{titulo}{Cadena de caracteres indicando la segregación que presenta el
mapa y el periodo al que hace referencia éste, separados por un espacio, por
ejemplo, "Admitidos 2021-I".}

\item{naTo0}{Si es \code{TRUE} (\emph{valor predeterminado}) los valores introducidos
como \code{NA} (\emph{not available}) se cambiarán por el valor de 0. Ajústelo a \code{FALSE}
para que no se realice tal cambio y mostrar en la caja de información la
leyenda "Sin Información".}

\item{colNA}{Cadena de caracteres indicando el color que tendrá la categoría
\code{NA} (\emph{si esta se presenta}). El valor por defecto es un gris muy claro.}

\item{centroideMapa}{Cadena de caracteres indicando el departamento que servirá
de centroide al momento de graficar el mapa. El valor por defecto es "CUNDINAMARCA".
Se emparejará parcialmente.}

\item{zoomMapa}{Valor numérico que indica el nivel de zoom del mapa
(\emph{usado por la función} \link[leaflet:map-methods]{setView()}). El valor por
defecto es \code{6}, entre mayor sea su valor más zoom se aplicará al mapa.}

\item{baldosas}{Vector de caracteres indicando los mapas base con los que se
realizará el mapa, sean los popularizados por Google Maps o por terceros.
Los valores aceptados son los admitidos por la función
\link[leaflet:addProviderTiles]{addProviderTiles()}, así mismo los valores por
defecto son \code{c("CartoDB.Positron", "Esri.WorldStreetMap", "Esri.NatGeoWorldMap")},
algunos otros valores pueden ser:
\itemize{
\item "Esri.DeLorme"
\item "Esri.WorldTerrain"
\item "Esri.WorldShadedRelief"
\item "Esri.WorldPhysical"
\item "Esri.OceanBasemap"
\item "Esri.WorldGrayCanvas"
\item "Esri.WorldImagery"
\item "Stamen.Toner"
\item "Stamen.TonerLite"
\item "Stamen.TonerLines"
\item "Stamen.Watercolor"
\item "Stamen.TonerHybrid"
}

La lista completa la puede consultar \href{http://leaflet-extras.github.io/leaflet-providers/preview/index.html}{aquí}}

\item{cortes}{Vector numérico indicando los cortes con los cuales se crearán
los intervalos. No aplica para el tipo de mapa "SiNoMpios", pues este es
binario. Para el tipo de mapa "DeptoMpio" se debe pasar una lista de la
siguiente manera \code{list(Deptos = c(), Mpios = c())}, pues requiere dos cortes,
uno para departamentos y otro para municipios.}

\item{colores}{Vector de caracteres indicando los colores para cada uno de los
intervalos con los que cuenta el mapa. Si no se introduce algún vector, se
usará una paleta predeterminada dependiendo del tipo de mapa.}

\item{showSedes}{Si es \code{TRUE} (\emph{valor predeterminado}) en el control de capas
(\emph{usado en la función} \link[leaflet:addLayersControl]{addLayersControl()})
aparecerá el grupo destinado a mostrar o no la ubicación de las distintas
sedes de la Universidad Nacional de Colombia. Ajústelo a \code{FALSE} para que en
el control de capas no aparezca dicha opción.}

\item{colSedes}{Vector de caracteres (\emph{de longitud 9}) indicando los colores
del icono de ubicación de las distintas sedes de la Universidad Nacional de
Colombia. Los colores permitidos son los que acepta la función
\link[leaflet:makeAwesomeIcon]{makeAwesomeIcon()}, es decir, "red", "darkred",
"lightred", "orange", "beige", "green", "darkgreen", "lightgreen", "blue",
"darkblue", "lightblue", "purple", "darkpurple", "pink", "cadetblue", "white",
"gray", "lightgray", "black".}

\item{opacidad}{Un número entre \eqn{[0, 1]} que indica la opacidad de las capas.}

\item{colBorde}{Cadena de caracteres indicando el color del borde de los
polígonos al momento de pasar el cursor sobre él.}

\item{compacto}{Si es \code{TRUE} (\emph{valor predeterminado}) el control de capas se
representará como un icono que se expande cuando se coloca el cursor sobre
él. Ajústelo a \code{FALSE} para que el control de capas siempre aparezca en su
estado expandido.}

\item{textSize}{Valor numérico que indica el tamaño del texto de las etiquetas
de los municipios. El valor para los departamentos será \eqn{+2px}.}

\item{limpio}{Si es \code{FALSE} (\emph{valor predeterminado}) se mostrará el MiniMapa,
la barra de escala y los botones para ver en pantalla completa, retornar zoom
y localización. Ajústelo a \code{TRUE} si desea omitir dichas herramientas adicionales
al mapa.}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
para graficar el mapa \strong{estático} y cuyo objetivo es personalizar pequeños
detalles de éste.
\itemize{
\item \code{anchoBorde}: Número decimal que indica el ancho de la línea de contorno
de los polígonos del mapa. El valor por defecto es \code{0.5}.
\item \code{labelX}, \code{labelY}: Cadena de caracteres indicando la etiqueta del eje
respectivo. El valor por defecto es \code{"Longitud"} y \code{"Latitud"} respectivamente.
\item \code{xlim}, \code{ylim}: Vector numérico que especifica los límites de los ejes respectivos.
\item \code{Legend}: Igual uso que \code{gg.Legend} en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{Labs}: Igual uso que \code{gg.Texto} en \code{\link[=Plot.Series]{Plot.Series()}}. Con la adición del
argumento \code{fill}, el cual especifica el título de leyenda. El valor por
defecto es \code{"Statistic"}. Si es \code{NULL}, se omitirá dicho título.
\item \code{Theme}: Igual uso que \code{gg.Tema} en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{Style}: Cadena de caracteres que indica el tipo de mapa a graficar.
Los valores permitidos son \code{"Intervalo"}, \code{"SiNo"}, \code{"Calor"} y \code{NA}
(\emph{valor predeterminado}). Se emparejará parcialmente.
\item \code{Text}: Lista que especifica aspectos como el color y tamaño de los títulos
de los polígonos. Para más información, consulte la función \link[ggplot2:ggsf]{geom_sf_text()}.
\item \code{scaleX}, \code{scaleY}: Vector numérico que especifica los puntos o cortes a
graficar en dicho eje. Sacado de la función \link[ggplot2:scale_continuous]{scale_x_continuous()}.
}}

\item{...}{Abc.}
}
\value{
Retorna el mapa (\emph{objeto widget de HTML}) creado mediante \code{Leaflet}, el cual
pertenece a la clase "leaflet" y "htmlwidget".
}
\description{
Esta función está planeada para facilitar la creación de mapas interactivos
compatible con plataformas móviles y de escritorio, además de estar diseñada
pensando en la simplicidad y el rendimiento. Esta utilidad produce mapas que
tienen controles para hacer zoom, desplazarse y alternar capas y puntos entre
mostrar y ocultar. Igualmente, permite incrustar mapas en webs, documentos
\verb{R Markdown} y aplicaciones \code{Shiny}. Todo lo anterior basado enteramente en la
librería \code{Leaflet}, la cual es la biblioteca \code{JavaScript} de código abierto más
popular para mapas interactivos.
}
\details{
Los vectores \code{depto} y \code{mpio} introducidos hacen referencia a atributos atómicos,
es decir, la pareja formada por \verb{(depto, mpio)} debe corresponder a un individuo.
En los argumentos no se acepta la entrada de objetos espaciales o polígonos.
}
\examples{
\dontshow{if (require("dplyr")) withAutoprint(\{ # examplesIf}
# library(dplyr)
df <- ejGraduados |> filter(YEAR == 2021) |>
  select(
    COD_DEP_NAC, COD_CIU_NAC, DEP_NAC, CIU_NAC, LON_CIU_NAC, LAT_CIU_NAC
  )
Plot.Mapa(
  datos    = df,
  depto    = COD_DEP_NAC,
  mpio     = COD_CIU_NAC,
  tipo     = "SiNoMpios",
  titulo   = "Graduados 2021-I",
  baldosas = c(
    "Esri.WorldPhysical", "Esri.DeLorme", "Esri.WorldShadedRelief",
    "Esri.WorldTerrain", "Esri.OceanBasemap"
  ),
  colores  = c("#10F235", "#00BCB5"),
  colSedes = rep("green", 9),
  opacidad = 0.6,
  colBorde = "#FF4D00",
  compacto = FALSE,
  textSize = 16,
  limpio   = TRUE
)
# ---------------------------------------------------------------------------
Plot.Mapa(
  datos  = df,
  depto  = COD_DEP_NAC,
  mpio   = COD_CIU_NAC,
  tipo   = "DeptoMpio",
  titulo = "Graduados 2021-I",
  cortes = list(
    Deptos = c(0, 10, 20, 50, 500, Inf), Mpios = c(0, 1, 5, 10, 100, Inf)
  ),
  colores = list(
    Deptos = c("#6812F2", "#5769F6", "#F6ED0D", "#EE6115", "#EC2525"),
    Mpios  = c("#E7F15D", "#ACBD37", "#E15E32", "#A82743", "#5C323E")
  )
)
\dontshow{\}) # examplesIf}
\dontshow{if (all(FALSE) && require("dplyr") && require("magrittr")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
# library(dplyr); library(magrittr)
ejSaberPro2020 \%>\%
  select(
    Code_Dept = COD_DEP_NAC,
    Code_Mun  = COD_CIU_NAC,
    Edad      = EDAD_MOD,
    PBM       = PBM_ORIG,
    ScoreGlobal   = PUNTAJE_GLOBAL,
    ScoreCompCiud = PUNT_COMP_CIUD,
    ScoreComuEscr = PUNT_COMU_ESCR,
    ScoreIngles   = PUNT_INGLES,
    ScoreLectCrit = PUNT_LECT_CRIT,
    ScoreRazCuant = PUNT_RAZO_CUANT
  ) \%$\%
  Plot.Mapa(
    datos         = .,
    depto         = Code_Dept,
    mpio          = Code_Mun,
    estadistico   = "Mediana",
    variable      = ScoreGlobal,
    tipo          = "DeptoMpio",
    titulo        = "P.Global 2020",
    naTo0         = FALSE,
    colNA         = "#472985",
    centroideMapa = "ANTIOQUIA",
    zoomMapa      = 8,
    cortes        = list(
      Deptos = c(0, 155, 170, 180, 185, Inf), Mpios = c(0, 50, 178, 200, 250, Inf)
    ),
    colores       = list(
      Deptos = c("#FF7D5A", "#FDBD7D", "#E5DF73", "#63D2A8", "#0055A1"),
      Mpios  = c("#E7F15D", "#ACBD37", "#E15E32", "#A82743", "#5C323E")
    ),
    showSedes     = FALSE
  )
\dontshow{\}) # examplesIf}
\dontshow{if (all(FALSE) && require("cowplot")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
# Ejemplo usando el caso estático (ggplot2)
# library(cowplot)
Plot.Mapa(
  datos     = df,
  depto     = COD_DEP_NAC,
  mpio      = COD_CIU_NAC,
  zoomIslas = TRUE,
  tipo      = "Mpios",
  titulo    = "N\u00daM. DE GRADUADOS \u00d7 MUNICIPIO",
  colNA     = "#4ACB46",
  cortes    = c(0, 1, 10, Inf),
  colores   = c("#009CC8", "#EE6115", "#EC2525"),
  opacidad  = 0.6,
  estatico  = TRUE,
  estilo    = list(
    Style = "Intervalo", Theme = 2, anchoBorde = 0.5,
    Legend = list(legend.position = "bottom", legend.direction = "horizontal"),
    Labs   = list(subtitle = "A\u00f1o 2021", caption = "(*) Lugar de Nacimiento", tag = "\u00ae")
  )
) -> listMaps
# library(cowplot); library(ggplot2)
# |    Tema    |             Mapa             |   y  | width |
# |:----------:|:----------------------------:|:----:|:-----:|
# | 1:6, 10:11 |          San Andrés          | 0.36 |  0.06 |
# |            | Providencia y Santa Catalina | 0.39 | 0.055 |
# |      9     |             ° ° °            | 0.36 |  0.07 |
# |            |             * * *            | 0.39 | 0.065 |
# |    12:14   |             ° ° °            | 0.33 |  0.11 |
# |            |             * * *            | 0.36 |  0.10 |
ggdraw() +
  draw_plot(listMaps$M_COL) +
  draw_plot(listMaps$M_SanAndres  , x = 0.27, y = 0.36, width = 0.060) +
  draw_plot(listMaps$M_Providencia, x = 0.33, y = 0.39, width = 0.055)
# ggplot2::ggsave("COL.png", width = 12, height = 10, dpi = 550)
\dontshow{\}) # examplesIf}
\dontshow{if (all(FALSE) && require("tibble") && require("cowplot")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
# library(tibble)
PIB <- tibble(
  DIVIPOLA = c(91,05,81,08,11,13,15,17,18,85,19,20,27,23,25,94,95,
               41,44,47,50,52,54,86,63,66,88,68,70,73,76,97,99),
  Valor    = c(883,177837,6574,52961,301491,NA,31208,19782,4718,17810,21244,
               23244,5069,20842,73592,443,943,19837,14503,16370,41923,18259,
               18598,4253,9837,19531,1711,74737,9842,25143,116238,337,799)
)
Plot.Mapa(
  datos     = PIB,
  depto     = DIVIPOLA,
  variable  = Valor,
  agregado  = FALSE,
  zoomIslas = TRUE,
  tipo      = "Deptos",
  naTo0     = FALSE,
  colNA     = "#543619",
  titulo    = "PIB \u00d7 DEPARTAMENTO",
  cortes    = c(0, 500, 5000, 20000, 30000, Inf),
  colores   = c("#FED600", "#02D46E", "#006389", "#FA006E", "#FC553C"),
  colBorde  = "#3A0F2D",
  estatico  = TRUE,
  textSize  = 0,
  estilo    = list(
    Style = "Intervalo", Theme = 7,
    Legend = list(legend.position = "bottom", legend.direction = "horizontal"),
    Labs = list(
      fill = "PIB", subtitle = "A Precios Corrientes",
      caption = "Para el periodo de 2021P (en miles de millones de pesos)"
    )
    # scaleX = seq(-82, -64, by = 1), scaleY = seq(-4, 14, by = 1)
  )
) -> listMaps
# Caso 1:
#   Dejando solamente la isla principal (San Andrés) y omitiendo
#   las contiguas (Providencia y Santa Catalina)
ggdraw() +
  draw_plot(listMaps$M_COL) +
  draw_plot(listMaps$M_SanAndres, x = 0.26, y = 0.8, width = 0.4)
# ggsave("COL.png", width = 12, height = 10, dpi = 550)
# Caso 2:
#   Conservando todo el departamento y sus distancias reales (no se modifica su polígono espacial)
ggdraw() +
  draw_plot(listMaps$M_COL) +
  draw_plot(listMaps$M_SanAndres, x = 0.27, y = 0.35, width = 0.08)
# ggsave("COL.png", width = 12, height = 10, dpi = 550)
\dontshow{\}) # examplesIf}
\dontshow{if (all(FALSE)) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
AreaVichada <- tibble(
  MunCode = c(99001, 99524, 99624, 99773), Area = c(12409, 20141, 2018, 65674)
)
Plot.Mapa(
  datos    = AreaVichada,
  mpio     = MunCode,
  variable = Area,
  agregado = FALSE,
  tipo     = "Mpios",
  titulo   = "\u00c1REA DE LOS MUNICIPIOS DEL\nDEPARTAMENTO DE VICHADA",
  naTo0    = FALSE,
  centroideMapa = "VICHADA",
  estatico = TRUE,
  estilo   = list(
    Style = "Calor", Theme = 9,
    Labs  = list(caption = "(*) En Metros Cuadrados"),
    Text  = list(color = "#011532", size = 3)
  )
)
\dontshow{\}) # examplesIf}
}
