% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSGB_lon_lat.R
\name{latitude}
\alias{latitude}
\alias{longitude}
\title{Un-project Transverse Mercator Eastings and Northings back to latitude and longitude.}
\usage{
latitude(data, easting, northing)

longitude(data, easting, northing)
}
\arguments{
\item{data}{a data frame containing OSGB coordinates}

\item{easting}{a numeric vector of easting coordinates}

\item{northing}{a numeric vector of northing coordinates}
}
\value{
A numeric vector of latitude or longitude values.
}
\description{
These functions convert OSGB (Ordnance Survey of Great Britain) coordinates, i.e. Transverse Mercator easting and northing coordinates,
for example, as provided by the UK Biobank.
\code{latitude} returns latitude values and \code{longitude} returns longitude values.
}
\examples{
osgb <- data.frame(east = c(393000, 461000, 438000), north = c(287000, 223000, 565000))
latitude(osgb, east, north)
longitude(osgb, east, north)
}
