% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coeffs.R
\name{coeffs}
\alias{coeffs}
\title{Calculate coefficients of a function's series expansion}
\usage{
coeffs(X, Ntrunc)
}
\arguments{
\item{X}{The discretised functions whose coefficients are required.
This should be a matrix with one row per function, and with \eqn{Ndisc} columns,
where \eqn{Ndisc} is the grid size of the discretisation.}

\item{Ntrunc}{The number of coefficients that are required.
The function returns coefficients 1,...,\eqn{Ntrunc}.}
}
\value{
The coefficients of \eqn{X} in its expansion in terms of sine functions.
See \insertCite{BKS2020}{USP} for more detail.
}
\description{
This function is used in InfKern to produce the kernel matrix from functional
data defined on the interval \eqn{[0,1]}. For further details see Section 7.4
of \insertCite{BKS2020}{USP}.
}
\examples{
t=seq(from=0,to=1,length.out=1000); X=t^2
U=coeffs(X,100)[1,]; L=5
plot(t,X,type="l")
approx=rep(0,1000)
for(l in 1:L){
approx=approx+qnorm(U[l])*sqrt(2)*sin((l-1/2)*pi*t)/((l-1/2)*pi)
lines(t,approx,col=l+1)
}
}
\references{
\insertRef{BKS2020}{USP}
}
