% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{Grocery_NE}
\alias{Grocery_NE}
\title{Data: Grocery_NE}
\format{
{
A dataframe with \emph{n} = 3114 observations and the following 28 variables
(levels of the variables listed in alphabetical order):
\itemize{
\item \strong{Id} (\code{int}): customer identification
\item \strong{Sex} (\code{chr}): customer’s sex at birth, (F or M)
\item \strong{Age} (\code{num}): customer's age (in years)
\item \strong{Tenure} (\code{factor}): Customer tenure in years (coded in classes: [0,1),
[1,3), [3,6), [6,10), [10,15), [15,25), [25,35))
\item \strong{Status} (\code{chr}): customers’ status (Active, Silent)
\item \strong{FavShop} (\code{chr}): store customers visit the most (NE.01, NE.02,...,
NE.07)
\item \strong{FavShop_Region} (\code{chr}) region where the favourite shop is located
(here, only North-East)
\item \strong{TotShops} (\code{num}): number of stores visited by the customer
\item \strong{WeekDay} (\code{chr}): preferred shopping day (1:Mon, 2:Tue,..., 7:Sun)
\item \strong{TimeSlot} (\code{chr}): preferred shopping time slot (08-12, 12-14, 14-17,
17-23)
\item \strong{Satisf}: (\code{chr}): Customer’s overall declared satisfaction with the
retailer (VLow, QLow, Low, Med, QHigh, High, VHigh)
\item \strong{Complaint} (\code{factor}): major weakness of the typically visited store
(Quality&Variety, Prices, Resupply, Staff, Crowded, Checkout)
\item \strong{NMonths} (\code{num}): number of months in which the customers visited a
store at least once
\item \strong{MonthExp} (\code{chr}) amount spent per month, in classes ([0,50),
[50,100), [100,150), [300,400), [200,300), [300,400), [400,600),
[600,800])
\item \strong{Transact_M} (\code{num}): transactions per month
\item \strong{TBP} (\code{num}): time between purchases
\item \strong{TotExp} (\code{num}): amount spent in the last 12 year
\item \strong{TotVisits} (\code{num}): total number of visits in the last year
\item \strong{Receipt} (\code{num}): average receipt (transaction value)
\item \strong{Visits_Regular} (\code{num}): score (ranging from 0 to 100) indicating the
regularity of customer’s shopping trips
\item \strong{Spending_Regular} (\code{num}) score (ranging from 0 to 100) indicating
the regularity of customer’s spending
\item \strong{Discount} (\code{num}): average discount on purchased products
\item \strong{CrossSelling} (\code{num}): index measuring how diverse a customer's
purchases are across different product categories
\item \strong{RecencyScore} (\code{num}): index reflecting how recently a customer
last interacted with a company (higher scores reflecting more recent
interactions)
\item \strong{MonetaryScore} (\code{num}): index reflecting the overall value of the
customer to the business
\item \strong{FrequencyScore} (\code{num}): index reflecting the regularity or
repetition of customer transactions, with higher scores indicating more
frequent purchases
}
}
}
\usage{
data(Grocery_NE)
}
\description{
This dataset contains the variables from a survey on a sample of customers from
a grocery chain operating in Italy. Specifically, data refer to the sub-sample
of customers who regularly shop in stores located in north-eastern Italian region.
Information is available on the activity observed in the last year (number of
visits and transactions, amount spent), on customers’ satisfaction with the
retailer, and on the perceived weakness of the most frequently visited store.
}
\keyword{datasets}
