% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hibbing_subwrapper__main.R
\name{hibbing-helpers}
\alias{hibbing-helpers}
\alias{apply_two_regression_hibbing18}
\title{Apply a Hibbing 2018 two-regression algorithm}
\usage{
apply_two_regression_hibbing18(
  which_algorithm = data.frame(Wear_Location = "Hip", Algorithm = 1),
  AG,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{which_algorithm}{a dataframe specifying which algorithm to use, based
on \code{Wear_Location} and \code{Algorithm} columns}

\item{AG}{data frame of ActiGraph data}

\item{verbose}{logical. Print updates to console?}

\item{...}{arguments passed to \code{\link{predict.TwoRegression}}}
}
\value{
a numeric vector of predicted energy expenditure values, expressed in
  metabolic equivalents
}
\description{
Applies the specified two-regression algorithm from
\href{https://pubmed.ncbi.nlm.nih.gov/29271847/}{Hibbing et al. (2018,
\emph{Med Sci Sports Exerc})} to data from the primary accelerometer and IMU
(if applicable)
}
\keyword{internal}
