% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vuniroot2.R
\name{vuniroot2}
\alias{vuniroot2}
\title{Vectorised One Dimensional Root (Zero) Finding}
\usage{
vuniroot2(
  y,
  f,
  interval = stop("must provide a length-2 `interval`"),
  tol = .Machine$double.eps^0.25,
  maxiter = 1000L
)
}
\arguments{
\item{y}{\link[base]{numeric} \link[base]{vector} of \eqn{y} values}

\item{f}{monotone \link[base]{function} \eqn{f(x)} whose roots are to be solved}

\item{interval}{\link[base]{length}-2 \link[base]{numeric} \link[base]{vector}}

\item{tol}{\link[base]{double} scalar, desired accuracy, i.e., convergence tolerance}

\item{maxiter}{\link[base]{integer} scalar, maximum number of iterations}
}
\value{
Function \code{\link[=vuniroot2]{vuniroot2()}} returns a \link[base]{numeric} \link[base]{vector} \eqn{x} as the solution of \eqn{y = f(x)} with given \link[base]{vector} \eqn{y}.
}
\description{
To solve a monotone function \eqn{y = f(x)} for a given \link[base]{vector} of \eqn{y} values.
}
\details{
Function \code{\link[=vuniroot2]{vuniroot2()}}, different from \link[rstpm2]{vuniroot}, does
\itemize{
\item{accept \code{NA_real_} as element(s) of \eqn{y}}
\item{handle the case when the analytic root is at \code{lower} and/or \code{upper}}
\item{return a root of
\code{Inf} (if \code{abs(f(lower)) >= abs(f(upper))}) or
\code{-Inf} (if \code{abs(f(lower)) < abs(f(upper))}),
when the function value \code{f(lower)} and \code{f(upper)} are not of opposite sign.}
}
}
\examples{
library(rstpm2)

# ?rstpm2::vuniroot does not accept NA \eqn{y}
tryCatch(vuniroot(function(x) x^2 - c(NA, 2:9), lower = 1, upper = 3), error = identity)

# ?rstpm2::vuniroot not good when the analytic root is at `lower` or `upper`
f <- function(x) x^2 - 1:9
vuniroot(f, lower = .99, upper = 3.001) # good
tryCatch(vuniroot(f, lower = 1, upper = 3, extendInt = 'no'), warning = identity)
tryCatch(vuniroot(f, lower = 1, upper = 3, extendInt = 'yes'), warning = identity)
tryCatch(vuniroot(f, lower = 1, upper = 3, extendInt = 'downX'), error = identity)
tryCatch(vuniroot(f, lower = 1, upper = 3, extendInt = 'upX'), warning = identity)

vuniroot2(c(NA, 1:9), f = function(x) x^2, interval = c(1, 3)) # all good

}
\keyword{internal}
