% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Troublemaker.R
\name{troublemaker}
\alias{troublemaker}
\title{Troublemaker}
\usage{
troublemaker(
  Rasterdomain = NULL,
  Rastercurrent = NULL,
  species_names = NULL,
  Rasterspecieslanduse = NULL,
  landuses = NULL,
  budget = NULL,
  Rastercurrentlanduse = NULL,
  name = "Problem",
  verbose = FALSE
)
}
\arguments{
\item{Rasterdomain}{A Raster object with any value in the cells that are part of the problem and NA values where the problem is not to be solved}

\item{Rastercurrent}{raster object of current suitability}

\item{species_names}{a vector with the names of species}

\item{Rasterspecieslanduse}{a list of species suitability for each landuse}

\item{landuses}{character vector with all landuses}

\item{budget}{maximum cost for the problem}

\item{Rastercurrentlanduse}{raster object of current landuses}

\item{name}{The name of the output file}

\item{verbose}{Logical whether messages will be written while the
function is generating calculations, defaults to FALSE}
}
\value{
A .dat file with the spatial problem formated for AMPL. This function is used for the side-effect of writing values to a file.
}
\description{
This function is a metafunction with several functions inside of it it takes several spatial objects and generates a .dat file with a spatial dataset for AMPL
}
\examples{
# Example 1 with current suitabilities
data(Species)
data(Current)
library(terra)
Test <- Species[[1]] |>
terra::unwrap()

Current <- terra::unwrap(Current)

# Generate the "Problem.dat" file

TroublemakeR::troublemaker(Rasterdomain =Test[[1]],
Rastercurrent = Current,
species_names = c("Spp1", "Spp2", "Spp3", "Spp4"),
name = "Problem")

# delete the file so the test on cran can pass this

file.remove("Problem.dat")

# Example 2 with landuse suitabilities

data(Species)
data("Species_Landuse")

library(terra)
Test <- Species[[1]] |>
terra::unwrap()

Species_Landuse <- Species_Landuse |> purrr::map(terra::unwrap)

# Generate the "Problem2.dat" file

TroublemakeR::troublemaker(Rasterdomain =Test[[1]],
Rasterspecieslanduse = Species_Landuse,
species_names = c("Spp1", "Spp2", "Spp3", "Spp4"),
landuses = c("Agriculture", "Forest", "Urban"),
name = "Problem2")

# delete the file so the test on cran can pass this

file.remove("Problem2.dat")

 # Example 3 with budget and transition cost

 data("CurrentLanduse")
 CurrentLU <- terra::unwrap(CurrentLanduse)
 TroublemakeR::troublemaker(Rasterdomain =Test[[1]],
 Rasterspecieslanduse = Species_Landuse,
 species_names = c("Spp1", "Spp2", "Spp3", "Spp4"),
 landuses = c("Agriculture", "Forest", "Urban"),
 Rastercurrentlanduse = CurrentLU,
 budget = 2,
 name = "Problem3",
 verbose = FALSE)

 file.remove("Problem3.dat")

}
\author{
Derek Corcoran
}
