% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilityFunctions.R
\name{day_of_year}
\alias{day_of_year}
\title{Calendar Day from Date}
\usage{
day_of_year(day, format = "\%Y-\%m-\%d")
}
\arguments{
\item{day}{\code{character} numerical date in standard format (e.g. \code{"2017-01-02"}, \code{"01-02"}, \code{"01/02/2017"} etc).}

\item{format}{\code{character} date format following \code{\link[base]{as.POSIXlt}} conventions. Default value = \code{"\%Y-\%m-\%d"}.}
}
\value{
\code{numeric} Julian day number, 1-366 (e.g. 1 for January 1st).
}
\description{
The function converts a date (day, month, year) to Calendar Day (day of year).
}
\examples{
  day_of_year(day    = "2017-04-22", 
              format = "\%Y-\%m-\%d")
  day_of_year(day    = "2017-04-22")
  day_of_year(day    = "04/22/2017", 
              format = "\%m/\%d/\%Y")

}
\seealso{
Other utility functions: 
\code{\link{airpressure_from_elev}()},
\code{\link{azimuth_angle}()},
\code{\link{daylength}()},
\code{\link{dec_angle}()},
\code{\link{solar_noon}()},
\code{\link{temperature conversions}},
\code{\link{zenith_angle}()}
}
\concept{utility functions}
