% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailty_sd.R
\name{frailty_Sd_internal}
\alias{frailty_Sd_internal}
\title{Internal Function for Frailty Standard Deviation for the 'Adapted Paik et Al.'s Model'}
\usage{
frailty_Sd_internal(
  optimal_params,
  time_axis,
  n_regressors,
  categories_range_min,
  categories_range_max,
  flag_full
)
}
\arguments{
\item{optimal_params}{Optimal parameter vector, estimated through multi-dimensional optimization of the log-likelihood function.}

\item{time_axis}{Partition of the temporal domain.}

\item{n_regressors}{Number of regressors of the dataset. This value must be provided to be able to correctly
compute the number of parameters of the model and, therefore, to check the dimension of the parameter vector.}

\item{categories_range_min}{Vector of minimum value (range) assumed by the parameters category.}

\item{categories_range_max}{Vector of maximum value (range) assumed by the parameters category.}

\item{flag_full}{Do we want to compute the full frailty standard deviation (second case)? If so, the flag must be TRUE,
otherwise (first case), FALSE.}
}
\value{
S3 class object 'FrailtyDispersion' containing both two numerical vectors of length equal to the number of intervals of the time-domain:
\itemize{
\item FrailtyVariance
\item FrailtyStandardDeviation
}
}
\description{
The function computes both the standard deviation and the variance of the time-dependent
frailty of the 'Adapted Paik et al.'s Model'.
}
\keyword{internal}
