% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anniversary.R
\name{anniversary}
\alias{anniversary}
\title{Number of Anniversaries Between Two \link[base]{Date}s}
\usage{
anniversary(to, from)
}
\arguments{
\item{to}{an R object convertible to \link[base]{POSIXlt},
end date/time}

\item{from}{an R object convertible to \link[base]{POSIXlt},
start date/time}
}
\value{
Function \link{anniversary} returns an \link[base]{integer} scalar or \link[base]{vector}.
}
\description{
Number of anniversaries between two dates.
}
\details{
\enumerate{
\item {Year difference between \code{from} and \code{to} dates are calculated}
\item {In either situation below, subtract one (1) year from the year difference obtained in Step 1.
\itemize{
\item {Month of \code{from} is later than month of \code{to};}
\item {Months of \code{from} and \code{to} are the same, but day of \code{from} is later than day of \code{to}.}
}
In either of such situations, the anniversary of the current year has not been reached.
}
\item {If any element from Step 2 is negative, \link[base]{stop}.}
}
}
