% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsonparser.R
\name{compilation_options}
\alias{compilation_options}
\title{Define compilations options}
\usage{
compilation_options(
  file = NULL,
  table = NULL,
  noutput = NULL,
  nquestions = NULL,
  seed = NULL,
  compile = NULL,
  xelatex = NULL,
  debug = NULL
)
}
\arguments{
\item{file}{Input file name}

\item{table}{Input table with student name and information}

\item{noutput}{Number of *different* exams/homeworks produced}

\item{nquestions}{Number of questions on each exam (Only on exams)}

\item{seed}{Pseudorandom seed to be used (This allows the result to be deterministic)}

\item{compile}{If TRUE, it tries to compile}

\item{xelatex}{If TRUE, it uses `XeLaTeX`}

\item{debug}{If TRUE, it doesn't remove auxiliary files generated by `LaTeX` when compiling}
}
\value{
A list of options to be passed to \code{\link{jsonexamparser}}, \code{\link{jsonhwparser}}.
}
\description{
This function provides the compilation options that can be passed to the jsonexamparser
}
\examples{
\dontrun{

file <-
    system.file(
        "extdata",
        "ExampleTexDocuments",
        "exam_testing_nquestions.tex", #Test exam that doesn't require a table
        package = "TexExamRandomizer")

temporalfile <- paste(tempfile(), ".tex", sep = "")

file.copy(file, temporalfile)
opt <- compilation_options(file = temporalfile)
jsonhwparser(opt)

}
}
\seealso{
Other jsoncompiler: 
\code{\link{ParsePreambleForOptions}()},
\code{\link{jsonexamparser}()},
\code{\link{jsonhwparser}()}
}
\concept{jsoncompiler}
