% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuringdocument.R
\name{FindStructure}
\alias{FindStructure}
\alias{FindBegin}
\alias{FindEnd}
\alias{FindCommand}
\title{Structuring functions}
\usage{
FindBegin(x, cmdName)

FindEnd(x, cmdName)

FindCommand(x, cmdName)
}
\arguments{
\item{x}{string vector, each line should represent one line of a text file or a section fo a text file.}

\item{cmdName}{Command to search for in \code{x}.}
}
\value{
Returns a numeric vector, indicating each occurrance of a start of a environment that looks like \\begin\{\code{cmdName}\}

Returns a numeric vector, indicating each occurrence of a start of a environment that looks like \\end\{\code{cmdName}\}

Returns a numeric vector, indicating each occurrence of the command \\\code{cmdName} found in the document.
}
\description{
These internal functions provide functionality to find environment names and their use
}
\details{
In \code{\link{FindBegin}} and \code{\link{FindEnd}}, \code{cmdName} refers to the name of the command that would start an environment. Following the 'LaTeX' convention of "\\begin\{\code{cmdName}\}" or "\\end\{\code{cmdName}\}" respectively. However, it is not a full throrough check.
They will only be found by this class if they are only preceded by alphanumeric characters and spaces, this is to force the user to use begin and end environments at the start of a new line. TODO: CONSIDER AYBE CHANGING THIS THIS, IT IS EASY.

On the other hand, in the function  \code{\link{FindCommand}}. It finds the command "\\\code{cmdName}". And in this case it is less rescrittive, as long as the line is not commented, it will find it.
Make sure to not write slashes before the "\\\code{cmdName}", since you might bug the program if it thinks you wrote the command but you just wrote some slashes and then the command name afterwards.

All functions don't search for commands if the commands have been commented with the latex comment command in the same line... don't try to use multiple line comments on latex please...

\strong{IMPORTANT}, instead of just writing something alphanumeric, these function actually use the  \code{cmdName} as a regular expression, which might be useful in many cases, but be careful with this.

TODO: Implement options for regular expressions
}
\seealso{
Other Structuring Document: 
\code{\link{CompileDocument}()},
\code{\link{DivideFile}()},
\code{\link{IsWellSectioned}()},
\code{\link{StructureDocument}()}
}
\concept{Structuring Document}
\keyword{internal}
