% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnswerSheets.R
\name{ConstructAnswerSheet}
\alias{ConstructAnswerSheet}
\title{ConstructAnswerSheet}
\usage{
ConstructAnswerSheet(Document, correctTag, wrongTag = NULL)
}
\arguments{
\item{Document}{Document, as defined in \code{\link{StructureDocument}}. Remember however that the function \code{\link{StructureDocument}} returns the document and the preamble together in a list.}

\item{correctTag}{Tag to identify the correct items.}

\item{wrongTag}{Tag that identifies the wrong items.}
}
\value{
Data Frame. With the following columns
\describe{
    \item{index}{Just an index running from 1 to \eqn{n}, where \eqn{n} is the numbe of rows}
    \item{For each layer of depth in the document:}{
    Four columns,
    \describe{
        \item{\code{<name of section>_original}}{Contains an integer identifying the numbering of this section in the original layer, as identified by the naming convention}
        \item{\code{<name of section command>_original}}{Contains an integer identifying the numbering of this item in the original section, as identified by the naming convention}
        \item{\code{<name of section>}}{Contains an integer identifying the numbering of this section in the current layer, as identified by the ordering of the  document inputted on this function}
        \item{\code{<name of section command>}}{Contains an integer identifying the numbering of this item in the current section, as identified by the ordering of the  document inputted on this function}
    }
    }
    \item{For the last layer of depth}{
    5 columns if the wrongTag is not NULL, 4 columns otherwise,
    \describe{
        \item{\code{<name of section>_original}}{Contains an integer identifying the numbering of this section in the original layer, as identified by the naming convention}
        \item{\code{<name of section command>_original}}{Contains an integer identifying the numbering of this item in the original section, as identified by the naming convention}
        \item{\code{<name of section>}}{Contains an integer identifying the numbering of this section in the current layer, as identified by the ordering of the  document inputted on this function}
        \item{\code{<correctTag>}}{
            Contains an integer identifying the numbering of this item in the current section, , as identified by the ordering of the  document inputted on this function

            If the \code{correctTag} wasn't found in this item, it will show \code{NA} instead. (This will only happen if \code{wrongTag} is not \code{NULL}, since otherwise this elements are omitted)}
        \item{\code{<wrongTag>}}{
            Contains an integer identifying the numbering of this item in the current section, as identified by the ordering of the  document inputted on this function

            If the \code{wrongTag} wasn't found in this item, it will show \code{NA} instead. (This will only happen if \code{wrongTag} is not \code{NULL}, since otherwise this elements are omitted)}
    }
    }
}
}
\description{
Constructs an answer sheet given a document as generated by \code{\link{StructureDocument}} by finding in the items the correct and wrong tags and describing where it found them.

Note that you must provide the document part only, \code{StructureDocument} gives back a \code{$preamble} and \code{$document}.

If \code{wrongTag} is left \code{NULL}, the answer sheet only shows information of the correct answers.

This answer sheet provides information for what answers are correct or incorrect, as well as their position within the original document, before any shuffling was done. (It uses the names of the document to decide whether the document was shuffled or not, since subsetting a list removes all attributes except for the names, this is the "safest" way to do it)

The intent of this function is to make it easy to find the answers for a randomized version of an exam.
}
\details{
The tags are just command of the type "\code{\\Tag}" that must be found somewhere that is not commented out inside the last item at the end of the tree structure. Usually you will want to use the tags that already identify the document items for this.

(For example, in the exam class, the tags \code{\\choice} and \code{\\CorrectChoice} could be used naturally, without having to introduce extra commands in the document)
}
\examples{

ConstructAnswerSheet(
    TexExamRandomizer::testdoc$document,
    "CorrectChoice",
    "choice"
)
}
\seealso{
\code{\link{FindExamAnswers}} for the exact underlying messy algorithm that controls how the table is created.

Other Extracting information: 
\code{\link{CountNumberOfSections}()},
\code{\link{FindExamAnswers}()},
\code{\link{GenerateShortAnswerSheet}()}
}
\concept{Extracting information}
