% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraint_functions.R
\name{getScoreAttributes}
\alias{getScoreAttributes}
\title{Retrieve constraints-related scores from solution}
\usage{
getScoreAttributes(constraints, item_idx, item_resp, item_ncat)
}
\arguments{
\item{constraints}{a \code{\linkS4class{constraints}} object.}

\item{item_idx}{item indices from a solution.}

\item{item_resp}{item scores for \code{item_idx}.}

\item{item_ncat}{number of score categories for \code{item_idx}.}
}
\description{
\code{\link{getScoreAttributes}} is a helper function for retrieving constraints-related scores from a solution.
}
\examples{
item_idx <-
  c( 29,  33,  26,  36,  34,
    295, 289, 296, 291, 126,
    133, 124, 134, 129,  38,
     47,  39,  41,  46,  45,
    167, 166, 170, 168, 113,
    116, 119, 117, 118, 114)

item_resp <-
  c( 1, 0, 1, 1, 0,
     0, 1, 1, 0, 0,
     1, 0, 1, 0, 1,
     1, 1, 1, 0, 1,
     0, 1, 1, 1, 1,
     1, 0, 1, 0, 1)

item_ncat <-
  c( 2, 2, 2, 2, 2,
     2, 2, 2, 2, 2,
     2, 2, 2, 2, 2,
     2, 2, 2, 2, 2,
     2, 2, 2, 2, 2,
     2, 2, 2, 2, 2)

getScoreAttributes(constraints_reading, item_idx, item_resp, item_ncat)

}
